@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [NotebookWorkspace].
 */
@PulumiTagMarker
public class NotebookWorkspaceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: NotebookWorkspaceArgs = NotebookWorkspaceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend NotebookWorkspaceArgsBuilder.() -> Unit) {
        val builder = NotebookWorkspaceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): NotebookWorkspace {
        val builtJavaResource =
            com.pulumi.azurenative.documentdb.NotebookWorkspace(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return NotebookWorkspace(builtJavaResource)
    }
}

/**
 * A notebook workspace resource
 * Azure REST API version: 2023-04-15. Prior API version in Azure Native 1.x: 2021-03-15.
 * Other available API versions: 2023-09-15, 2023-09-15-preview, 2023-11-15, 2023-11-15-preview, 2024-02-15-preview.
 * ## Example Usage
 * ### CosmosDBNotebookWorkspaceCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var notebookWorkspace = new AzureNative.DocumentDB.NotebookWorkspace("notebookWorkspace", new()
 *     {
 *         AccountName = "ddb1",
 *         NotebookWorkspaceName = "default",
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/documentdb/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := documentdb.NewNotebookWorkspace(ctx, "notebookWorkspace", &documentdb.NotebookWorkspaceArgs{
 * 			AccountName:           pulumi.String("ddb1"),
 * 			NotebookWorkspaceName: pulumi.String("default"),
 * 			ResourceGroupName:     pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.documentdb.NotebookWorkspace;
 * import com.pulumi.azurenative.documentdb.NotebookWorkspaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var notebookWorkspace = new NotebookWorkspace("notebookWorkspace", NotebookWorkspaceArgs.builder()
 *             .accountName("ddb1")
 *             .notebookWorkspaceName("default")
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:documentdb:NotebookWorkspace default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/notebookWorkspaces/{notebookWorkspaceName}
 * ```
 */
public class NotebookWorkspace internal constructor(
    override val javaResource: com.pulumi.azurenative.documentdb.NotebookWorkspace,
) : KotlinCustomResource(javaResource, NotebookWorkspaceMapper) {
    /**
     * The name of the database account.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Specifies the endpoint of Notebook server.
     */
    public val notebookServerEndpoint: Output<String>
        get() = javaResource.notebookServerEndpoint().applyValue({ args0 -> args0 })

    /**
     * Status of the notebook workspace. Possible values are: Creating, Online, Deleting, Failed, Updating.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The type of Azure resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object NotebookWorkspaceMapper : ResourceMapper<NotebookWorkspace> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.documentdb.NotebookWorkspace::class == javaResource::class

    override fun map(javaResource: Resource): NotebookWorkspace = NotebookWorkspace(
        javaResource as
            com.pulumi.azurenative.documentdb.NotebookWorkspace,
    )
}

/**
 * @see [NotebookWorkspace].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [NotebookWorkspace].
 */
public suspend fun notebookWorkspace(
    name: String,
    block: suspend NotebookWorkspaceResourceBuilder.() -> Unit,
): NotebookWorkspace {
    val builder = NotebookWorkspaceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [NotebookWorkspace].
 * @param name The _unique_ name of the resulting resource.
 */
public fun notebookWorkspace(name: String): NotebookWorkspace {
    val builder = NotebookWorkspaceResourceBuilder()
    builder.name(name)
    return builder.build()
}
