@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin

import com.pulumi.azurenative.documentdb.kotlin.outputs.SqlDatabaseGetPropertiesResponseOptions
import com.pulumi.azurenative.documentdb.kotlin.outputs.SqlDatabaseGetPropertiesResponseResource
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.documentdb.kotlin.outputs.SqlDatabaseGetPropertiesResponseOptions.Companion.toKotlin as sqlDatabaseGetPropertiesResponseOptionsToKotlin
import com.pulumi.azurenative.documentdb.kotlin.outputs.SqlDatabaseGetPropertiesResponseResource.Companion.toKotlin as sqlDatabaseGetPropertiesResponseResourceToKotlin

/**
 * Builder for [SqlResourceSqlDatabase].
 */
@PulumiTagMarker
public class SqlResourceSqlDatabaseResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SqlResourceSqlDatabaseArgs = SqlResourceSqlDatabaseArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SqlResourceSqlDatabaseArgsBuilder.() -> Unit) {
        val builder = SqlResourceSqlDatabaseArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SqlResourceSqlDatabase {
        val builtJavaResource =
            com.pulumi.azurenative.documentdb.SqlResourceSqlDatabase(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return SqlResourceSqlDatabase(builtJavaResource)
    }
}

/**
 * An Azure Cosmos DB SQL database.
 * Azure REST API version: 2023-04-15. Prior API version in Azure Native 1.x: 2021-03-15.
 * Other available API versions: 2019-08-01, 2023-03-15-preview, 2023-09-15, 2023-09-15-preview, 2023-11-15, 2023-11-15-preview, 2024-02-15-preview.
 * ## Example Usage
 * ### CosmosDBSqlDatabaseCreateUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlResourceSqlDatabase = new AzureNative.DocumentDB.SqlResourceSqlDatabase("sqlResourceSqlDatabase", new()
 *     {
 *         AccountName = "ddb1",
 *         DatabaseName = "databaseName",
 *         Location = "West US",
 *         Options = null,
 *         Resource = new AzureNative.DocumentDB.Inputs.SqlDatabaseResourceArgs
 *         {
 *             Id = "databaseName",
 *         },
 *         ResourceGroupName = "rg1",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/documentdb/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := documentdb.NewSqlResourceSqlDatabase(ctx, "sqlResourceSqlDatabase", &documentdb.SqlResourceSqlDatabaseArgs{
 * 			AccountName:  pulumi.String("ddb1"),
 * 			DatabaseName: pulumi.String("databaseName"),
 * 			Location:     pulumi.String("West US"),
 * 			Options:      nil,
 * 			Resource: &documentdb.SqlDatabaseResourceArgs{
 * 				Id: pulumi.String("databaseName"),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Tags:              nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.documentdb.SqlResourceSqlDatabase;
 * import com.pulumi.azurenative.documentdb.SqlResourceSqlDatabaseArgs;
 * import com.pulumi.azurenative.documentdb.inputs.CreateUpdateOptionsArgs;
 * import com.pulumi.azurenative.documentdb.inputs.SqlDatabaseResourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlResourceSqlDatabase = new SqlResourceSqlDatabase("sqlResourceSqlDatabase", SqlResourceSqlDatabaseArgs.builder()
 *             .accountName("ddb1")
 *             .databaseName("databaseName")
 *             .location("West US")
 *             .options()
 *             .resource(SqlDatabaseResourceArgs.builder()
 *                 .id("databaseName")
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:documentdb:SqlResourceSqlDatabase databaseName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}
 * ```
 */
public class SqlResourceSqlDatabase internal constructor(
    override val javaResource: com.pulumi.azurenative.documentdb.SqlResourceSqlDatabase,
) : KotlinCustomResource(javaResource, SqlResourceSqlDatabaseMapper) {
    /**
     * The location of the resource group to which the resource belongs.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the ARM resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    public val options: Output<SqlDatabaseGetPropertiesResponseOptions>?
        get() = javaResource.options().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    sqlDatabaseGetPropertiesResponseOptionsToKotlin(args0)
                })
            }).orElse(null)
        })

    public val resource: Output<SqlDatabaseGetPropertiesResponseResource>?
        get() = javaResource.resource().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    sqlDatabaseGetPropertiesResponseResourceToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example, the default experience for a template type is set with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of Azure resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object SqlResourceSqlDatabaseMapper : ResourceMapper<SqlResourceSqlDatabase> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.documentdb.SqlResourceSqlDatabase::class == javaResource::class

    override fun map(javaResource: Resource): SqlResourceSqlDatabase =
        SqlResourceSqlDatabase(
            javaResource as
                com.pulumi.azurenative.documentdb.SqlResourceSqlDatabase,
        )
}

/**
 * @see [SqlResourceSqlDatabase].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SqlResourceSqlDatabase].
 */
public suspend fun sqlResourceSqlDatabase(
    name: String,
    block: suspend SqlResourceSqlDatabaseResourceBuilder.() -> Unit,
): SqlResourceSqlDatabase {
    val builder = SqlResourceSqlDatabaseResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SqlResourceSqlDatabase].
 * @param name The _unique_ name of the resulting resource.
 */
public fun sqlResourceSqlDatabase(name: String): SqlResourceSqlDatabase {
    val builder = SqlResourceSqlDatabaseResourceBuilder()
    builder.name(name)
    return builder.build()
}
