@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin

import com.pulumi.azurenative.documentdb.kotlin.outputs.SqlStoredProcedureGetPropertiesResponseResource
import com.pulumi.azurenative.documentdb.kotlin.outputs.SqlStoredProcedureGetPropertiesResponseResource.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [SqlResourceSqlStoredProcedure].
 */
@PulumiTagMarker
public class SqlResourceSqlStoredProcedureResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SqlResourceSqlStoredProcedureArgs = SqlResourceSqlStoredProcedureArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SqlResourceSqlStoredProcedureArgsBuilder.() -> Unit) {
        val builder = SqlResourceSqlStoredProcedureArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SqlResourceSqlStoredProcedure {
        val builtJavaResource =
            com.pulumi.azurenative.documentdb.SqlResourceSqlStoredProcedure(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return SqlResourceSqlStoredProcedure(builtJavaResource)
    }
}

/**
 * An Azure Cosmos DB storedProcedure.
 * Azure REST API version: 2023-04-15. Prior API version in Azure Native 1.x: 2021-03-15.
 * Other available API versions: 2019-08-01, 2023-03-15-preview, 2023-09-15, 2023-09-15-preview, 2023-11-15, 2023-11-15-preview, 2024-02-15-preview.
 * ## Example Usage
 * ### CosmosDBSqlStoredProcedureCreateUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlResourceSqlStoredProcedure = new AzureNative.DocumentDB.SqlResourceSqlStoredProcedure("sqlResourceSqlStoredProcedure", new()
 *     {
 *         AccountName = "ddb1",
 *         ContainerName = "containerName",
 *         DatabaseName = "databaseName",
 *         Options = null,
 *         Resource = new AzureNative.DocumentDB.Inputs.SqlStoredProcedureResourceArgs
 *         {
 *             Body = "body",
 *             Id = "storedProcedureName",
 *         },
 *         ResourceGroupName = "rg1",
 *         StoredProcedureName = "storedProcedureName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/documentdb/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := documentdb.NewSqlResourceSqlStoredProcedure(ctx, "sqlResourceSqlStoredProcedure", &documentdb.SqlResourceSqlStoredProcedureArgs{
 * 			AccountName:   pulumi.String("ddb1"),
 * 			ContainerName: pulumi.String("containerName"),
 * 			DatabaseName:  pulumi.String("databaseName"),
 * 			Options:       nil,
 * 			Resource: &documentdb.SqlStoredProcedureResourceArgs{
 * 				Body: pulumi.String("body"),
 * 				Id:   pulumi.String("storedProcedureName"),
 * 			},
 * 			ResourceGroupName:   pulumi.String("rg1"),
 * 			StoredProcedureName: pulumi.String("storedProcedureName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.documentdb.SqlResourceSqlStoredProcedure;
 * import com.pulumi.azurenative.documentdb.SqlResourceSqlStoredProcedureArgs;
 * import com.pulumi.azurenative.documentdb.inputs.CreateUpdateOptionsArgs;
 * import com.pulumi.azurenative.documentdb.inputs.SqlStoredProcedureResourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlResourceSqlStoredProcedure = new SqlResourceSqlStoredProcedure("sqlResourceSqlStoredProcedure", SqlResourceSqlStoredProcedureArgs.builder()
 *             .accountName("ddb1")
 *             .containerName("containerName")
 *             .databaseName("databaseName")
 *             .options()
 *             .resource(SqlStoredProcedureResourceArgs.builder()
 *                 .body("body")
 *                 .id("storedProcedureName")
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .storedProcedureName("storedProcedureName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:documentdb:SqlResourceSqlStoredProcedure storedProcedureName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}/storedProcedures/{storedProcedureName}
 * ```
 */
public class SqlResourceSqlStoredProcedure internal constructor(
    override val javaResource: com.pulumi.azurenative.documentdb.SqlResourceSqlStoredProcedure,
) : KotlinCustomResource(javaResource, SqlResourceSqlStoredProcedureMapper) {
    /**
     * The location of the resource group to which the resource belongs.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the ARM resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    public val resource: Output<SqlStoredProcedureGetPropertiesResponseResource>?
        get() = javaResource.resource().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example, the default experience for a template type is set with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of Azure resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object SqlResourceSqlStoredProcedureMapper : ResourceMapper<SqlResourceSqlStoredProcedure> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.documentdb.SqlResourceSqlStoredProcedure::class == javaResource::class

    override fun map(javaResource: Resource): SqlResourceSqlStoredProcedure =
        SqlResourceSqlStoredProcedure(
            javaResource as
                com.pulumi.azurenative.documentdb.SqlResourceSqlStoredProcedure,
        )
}

/**
 * @see [SqlResourceSqlStoredProcedure].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SqlResourceSqlStoredProcedure].
 */
public suspend fun sqlResourceSqlStoredProcedure(
    name: String,
    block: suspend SqlResourceSqlStoredProcedureResourceBuilder.() -> Unit,
):
    SqlResourceSqlStoredProcedure {
    val builder = SqlResourceSqlStoredProcedureResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SqlResourceSqlStoredProcedure].
 * @param name The _unique_ name of the resulting resource.
 */
public fun sqlResourceSqlStoredProcedure(name: String): SqlResourceSqlStoredProcedure {
    val builder = SqlResourceSqlStoredProcedureResourceBuilder()
    builder.name(name)
    return builder.build()
}
