@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin

import com.pulumi.azurenative.documentdb.ThroughputPoolArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * An Azure Cosmos DB Throughputpool.
 * Azure REST API version: 2023-11-15-preview.
 * Other available API versions: 2024-02-15-preview.
 * ## Example Usage
 * ### CosmosDB ThroughputPool Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var throughputPool = new AzureNative.DocumentDB.ThroughputPool("throughputPool", new()
 *     {
 *         Location = "westus2",
 *         MaxThroughput = 10000,
 *         ResourceGroupName = "rg1",
 *         Tags = null,
 *         ThroughputPoolName = "tp1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/documentdb/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := documentdb.NewThroughputPool(ctx, "throughputPool", &documentdb.ThroughputPoolArgs{
 * 			Location:           pulumi.String("westus2"),
 * 			MaxThroughput:      pulumi.Int(10000),
 * 			ResourceGroupName:  pulumi.String("rg1"),
 * 			Tags:               nil,
 * 			ThroughputPoolName: pulumi.String("tp1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.documentdb.ThroughputPool;
 * import com.pulumi.azurenative.documentdb.ThroughputPoolArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var throughputPool = new ThroughputPool("throughputPool", ThroughputPoolArgs.builder()
 *             .location("westus2")
 *             .maxThroughput(10000)
 *             .resourceGroupName("rg1")
 *             .tags()
 *             .throughputPoolName("tp1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:documentdb:ThroughputPool tp1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/throughputPools/{throughputPoolName}
 * ```
 * @property location The geo-location where the resource lives
 * @property maxThroughput Value for throughput to be shared among CosmosDB resources in the pool.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 * @property throughputPoolName Cosmos DB Throughput Pool name.
 */
public data class ThroughputPoolArgs(
    public val location: Output<String>? = null,
    public val maxThroughput: Output<Int>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val throughputPoolName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.ThroughputPoolArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.ThroughputPoolArgs =
        com.pulumi.azurenative.documentdb.ThroughputPoolArgs.builder()
            .location(location?.applyValue({ args0 -> args0 }))
            .maxThroughput(maxThroughput?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .throughputPoolName(throughputPoolName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ThroughputPoolArgs].
 */
@PulumiTagMarker
public class ThroughputPoolArgsBuilder internal constructor() {
    private var location: Output<String>? = null

    private var maxThroughput: Output<Int>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var throughputPoolName: Output<String>? = null

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("qrqhaklocgtvahjo")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Value for throughput to be shared among CosmosDB resources in the pool.
     */
    @JvmName("glrnlikbgjdjyxse")
    public suspend fun maxThroughput(`value`: Output<Int>) {
        this.maxThroughput = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("pjqdghhyhnbrtwyg")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("mqxlbbuhjwrkspcr")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Cosmos DB Throughput Pool name.
     */
    @JvmName("jibyospvuuclcjxy")
    public suspend fun throughputPoolName(`value`: Output<String>) {
        this.throughputPoolName = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("isdbnfxjrhwvxxbk")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Value for throughput to be shared among CosmosDB resources in the pool.
     */
    @JvmName("nbrrsqjfagnshqom")
    public suspend fun maxThroughput(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxThroughput = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("piupoytjtyxhwabg")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("jpigpjqmyumygxud")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("qrcyupkbcdptjljb")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Cosmos DB Throughput Pool name.
     */
    @JvmName("aiaxboepgvrembql")
    public suspend fun throughputPoolName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.throughputPoolName = mapped
    }

    internal fun build(): ThroughputPoolArgs = ThroughputPoolArgs(
        location = location,
        maxThroughput = maxThroughput,
        resourceGroupName = resourceGroupName,
        tags = tags,
        throughputPoolName = throughputPoolName,
    )
}
