@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Which authentication method Cassandra should use to authenticate clients. 'None' turns off authentication, so should not be used except in emergencies. 'Cassandra' is the default password based authentication. The default is 'Cassandra'.
 */
public enum class AuthenticationMethod(
    public val javaValue: com.pulumi.azurenative.documentdb.enums.AuthenticationMethod,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.enums.AuthenticationMethod> {
    None(com.pulumi.azurenative.documentdb.enums.AuthenticationMethod.None),
    Cassandra(com.pulumi.azurenative.documentdb.enums.AuthenticationMethod.Cassandra),
    Ldap(com.pulumi.azurenative.documentdb.enums.AuthenticationMethod.Ldap),
    ;

    override fun toJava(): com.pulumi.azurenative.documentdb.enums.AuthenticationMethod = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.documentdb.enums.AuthenticationMethod):
            AuthenticationMethod = AuthenticationMethod.values().first { it.javaValue == javaType }
    }
}
