@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The datatype for which the indexing behavior is applied to.
 */
public enum class DataType(
    public val javaValue: com.pulumi.azurenative.documentdb.enums.DataType,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.enums.DataType> {
    String(com.pulumi.azurenative.documentdb.enums.DataType.String),
    Number(com.pulumi.azurenative.documentdb.enums.DataType.Number),
    Point(com.pulumi.azurenative.documentdb.enums.DataType.Point),
    Polygon(com.pulumi.azurenative.documentdb.enums.DataType.Polygon),
    LineString(com.pulumi.azurenative.documentdb.enums.DataType.LineString),
    MultiPolygon(com.pulumi.azurenative.documentdb.enums.DataType.MultiPolygon),
    ;

    override fun toJava(): com.pulumi.azurenative.documentdb.enums.DataType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.documentdb.enums.DataType): DataType =
            DataType.values().first { it.javaValue == javaType }
    }
}
