@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Indicates the kind of algorithm used for partitioning. For MultiHash, multiple partition keys (upto three maximum) are supported for container create
 */
public enum class PartitionKind(
    public val javaValue: com.pulumi.azurenative.documentdb.enums.PartitionKind,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.enums.PartitionKind> {
    Hash(com.pulumi.azurenative.documentdb.enums.PartitionKind.Hash),
    Range(com.pulumi.azurenative.documentdb.enums.PartitionKind.Range),
    MultiHash(com.pulumi.azurenative.documentdb.enums.PartitionKind.MultiHash),
    ;

    override fun toJava(): com.pulumi.azurenative.documentdb.enums.PartitionKind = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.documentdb.enums.PartitionKind):
            PartitionKind = PartitionKind.values().first { it.javaValue == javaType }
    }
}
