@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.inputs

import com.pulumi.azurenative.documentdb.inputs.CassandraErrorArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property additionalErrorInfo Additional information about the error.
 * @property code The code of error that occurred.
 * @property message The message of the error.
 * @property target The target resource of the error.
 */
public data class CassandraErrorArgs(
    public val additionalErrorInfo: Output<String>? = null,
    public val code: Output<String>? = null,
    public val message: Output<String>? = null,
    public val target: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.inputs.CassandraErrorArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.inputs.CassandraErrorArgs =
        com.pulumi.azurenative.documentdb.inputs.CassandraErrorArgs.builder()
            .additionalErrorInfo(additionalErrorInfo?.applyValue({ args0 -> args0 }))
            .code(code?.applyValue({ args0 -> args0 }))
            .message(message?.applyValue({ args0 -> args0 }))
            .target(target?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CassandraErrorArgs].
 */
@PulumiTagMarker
public class CassandraErrorArgsBuilder internal constructor() {
    private var additionalErrorInfo: Output<String>? = null

    private var code: Output<String>? = null

    private var message: Output<String>? = null

    private var target: Output<String>? = null

    /**
     * @param value Additional information about the error.
     */
    @JvmName("ugpctndywnpgskcp")
    public suspend fun additionalErrorInfo(`value`: Output<String>) {
        this.additionalErrorInfo = value
    }

    /**
     * @param value The code of error that occurred.
     */
    @JvmName("ltlbjnjfghfwijsp")
    public suspend fun code(`value`: Output<String>) {
        this.code = value
    }

    /**
     * @param value The message of the error.
     */
    @JvmName("nbrnyforijtqcklj")
    public suspend fun message(`value`: Output<String>) {
        this.message = value
    }

    /**
     * @param value The target resource of the error.
     */
    @JvmName("rleyrsqcnatnsxln")
    public suspend fun target(`value`: Output<String>) {
        this.target = value
    }

    /**
     * @param value Additional information about the error.
     */
    @JvmName("skyshqccyvnoqohe")
    public suspend fun additionalErrorInfo(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.additionalErrorInfo = mapped
    }

    /**
     * @param value The code of error that occurred.
     */
    @JvmName("vodennolggrioihj")
    public suspend fun code(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.code = mapped
    }

    /**
     * @param value The message of the error.
     */
    @JvmName("spwvlbxgbsjuiqpd")
    public suspend fun message(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.message = mapped
    }

    /**
     * @param value The target resource of the error.
     */
    @JvmName("bvbjhacsxpaofqqt")
    public suspend fun target(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.target = mapped
    }

    internal fun build(): CassandraErrorArgs = CassandraErrorArgs(
        additionalErrorInfo = additionalErrorInfo,
        code = code,
        message = message,
        target = target,
    )
}
