@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.inputs

import com.pulumi.azurenative.documentdb.inputs.CassandraSchemaArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Cosmos DB Cassandra table schema
 * @property clusterKeys List of cluster key.
 * @property columns List of Cassandra table columns.
 * @property partitionKeys List of partition key.
 */
public data class CassandraSchemaArgs(
    public val clusterKeys: Output<List<ClusterKeyArgs>>? = null,
    public val columns: Output<List<ColumnArgs>>? = null,
    public val partitionKeys: Output<List<CassandraPartitionKeyArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.inputs.CassandraSchemaArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.inputs.CassandraSchemaArgs =
        com.pulumi.azurenative.documentdb.inputs.CassandraSchemaArgs.builder()
            .clusterKeys(
                clusterKeys?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .columns(
                columns?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .partitionKeys(
                partitionKeys?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [CassandraSchemaArgs].
 */
@PulumiTagMarker
public class CassandraSchemaArgsBuilder internal constructor() {
    private var clusterKeys: Output<List<ClusterKeyArgs>>? = null

    private var columns: Output<List<ColumnArgs>>? = null

    private var partitionKeys: Output<List<CassandraPartitionKeyArgs>>? = null

    /**
     * @param value List of cluster key.
     */
    @JvmName("poxvibvtamdovjgc")
    public suspend fun clusterKeys(`value`: Output<List<ClusterKeyArgs>>) {
        this.clusterKeys = value
    }

    @JvmName("bkhdkcpxurswnndm")
    public suspend fun clusterKeys(vararg values: Output<ClusterKeyArgs>) {
        this.clusterKeys = Output.all(values.asList())
    }

    /**
     * @param values List of cluster key.
     */
    @JvmName("bvbgfgdeqlnjsbci")
    public suspend fun clusterKeys(values: List<Output<ClusterKeyArgs>>) {
        this.clusterKeys = Output.all(values)
    }

    /**
     * @param value List of Cassandra table columns.
     */
    @JvmName("umkrihwytnrfphnn")
    public suspend fun columns(`value`: Output<List<ColumnArgs>>) {
        this.columns = value
    }

    @JvmName("oyyaqiihyffexstu")
    public suspend fun columns(vararg values: Output<ColumnArgs>) {
        this.columns = Output.all(values.asList())
    }

    /**
     * @param values List of Cassandra table columns.
     */
    @JvmName("jiastedxehjgovni")
    public suspend fun columns(values: List<Output<ColumnArgs>>) {
        this.columns = Output.all(values)
    }

    /**
     * @param value List of partition key.
     */
    @JvmName("vrwmltxsqrcgvaqo")
    public suspend fun partitionKeys(`value`: Output<List<CassandraPartitionKeyArgs>>) {
        this.partitionKeys = value
    }

    @JvmName("yernoivtqusqlngk")
    public suspend fun partitionKeys(vararg values: Output<CassandraPartitionKeyArgs>) {
        this.partitionKeys = Output.all(values.asList())
    }

    /**
     * @param values List of partition key.
     */
    @JvmName("egbjujlyvtadomey")
    public suspend fun partitionKeys(values: List<Output<CassandraPartitionKeyArgs>>) {
        this.partitionKeys = Output.all(values)
    }

    /**
     * @param value List of cluster key.
     */
    @JvmName("uxtjhrcftvgclolx")
    public suspend fun clusterKeys(`value`: List<ClusterKeyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterKeys = mapped
    }

    /**
     * @param argument List of cluster key.
     */
    @JvmName("ekicrqtxdcgvharn")
    public suspend fun clusterKeys(argument: List<suspend ClusterKeyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { ClusterKeyArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.clusterKeys = mapped
    }

    /**
     * @param argument List of cluster key.
     */
    @JvmName("ymxjflxxuhkuwwyh")
    public suspend fun clusterKeys(vararg argument: suspend ClusterKeyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { ClusterKeyArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.clusterKeys = mapped
    }

    /**
     * @param argument List of cluster key.
     */
    @JvmName("ieahfpydahgiveln")
    public suspend fun clusterKeys(argument: suspend ClusterKeyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ClusterKeyArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.clusterKeys = mapped
    }

    /**
     * @param values List of cluster key.
     */
    @JvmName("octrbfjyfaluhktn")
    public suspend fun clusterKeys(vararg values: ClusterKeyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clusterKeys = mapped
    }

    /**
     * @param value List of Cassandra table columns.
     */
    @JvmName("ciedqspbbgkvagni")
    public suspend fun columns(`value`: List<ColumnArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.columns = mapped
    }

    /**
     * @param argument List of Cassandra table columns.
     */
    @JvmName("wlxjgfgsijtjhwax")
    public suspend fun columns(argument: List<suspend ColumnArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { ColumnArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.columns = mapped
    }

    /**
     * @param argument List of Cassandra table columns.
     */
    @JvmName("iapelpgolwvrxcim")
    public suspend fun columns(vararg argument: suspend ColumnArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { ColumnArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.columns = mapped
    }

    /**
     * @param argument List of Cassandra table columns.
     */
    @JvmName("vbeibtftvmcrjdyb")
    public suspend fun columns(argument: suspend ColumnArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ColumnArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.columns = mapped
    }

    /**
     * @param values List of Cassandra table columns.
     */
    @JvmName("eobwicxjwmpfuhly")
    public suspend fun columns(vararg values: ColumnArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.columns = mapped
    }

    /**
     * @param value List of partition key.
     */
    @JvmName("gukqoxlgvhgtrbkx")
    public suspend fun partitionKeys(`value`: List<CassandraPartitionKeyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partitionKeys = mapped
    }

    /**
     * @param argument List of partition key.
     */
    @JvmName("idgqxfggfpjgvlmr")
    public suspend
    fun partitionKeys(argument: List<suspend CassandraPartitionKeyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            CassandraPartitionKeyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.partitionKeys = mapped
    }

    /**
     * @param argument List of partition key.
     */
    @JvmName("prnqbkqtieaikbno")
    public suspend fun partitionKeys(
        vararg
        argument: suspend CassandraPartitionKeyArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            CassandraPartitionKeyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.partitionKeys = mapped
    }

    /**
     * @param argument List of partition key.
     */
    @JvmName("fvgwuwrrshodbdmv")
    public suspend fun partitionKeys(argument: suspend CassandraPartitionKeyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(CassandraPartitionKeyArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.partitionKeys = mapped
    }

    /**
     * @param values List of partition key.
     */
    @JvmName("jbjlugrjnciepxat")
    public suspend fun partitionKeys(vararg values: CassandraPartitionKeyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.partitionKeys = mapped
    }

    internal fun build(): CassandraSchemaArgs = CassandraSchemaArgs(
        clusterKeys = clusterKeys,
        columns = columns,
        partitionKeys = partitionKeys,
    )
}
