@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.inputs

import com.pulumi.azurenative.documentdb.inputs.CassandraViewResourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Cosmos DB Cassandra view resource object
 * @property id Name of the Cosmos DB Cassandra view
 * @property viewDefinition View Definition of the Cosmos DB Cassandra view
 */
public data class CassandraViewResourceArgs(
    public val id: Output<String>,
    public val viewDefinition: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.inputs.CassandraViewResourceArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.inputs.CassandraViewResourceArgs =
        com.pulumi.azurenative.documentdb.inputs.CassandraViewResourceArgs.builder()
            .id(id.applyValue({ args0 -> args0 }))
            .viewDefinition(viewDefinition.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CassandraViewResourceArgs].
 */
@PulumiTagMarker
public class CassandraViewResourceArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var viewDefinition: Output<String>? = null

    /**
     * @param value Name of the Cosmos DB Cassandra view
     */
    @JvmName("eyndhtaqqtwwovmt")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value View Definition of the Cosmos DB Cassandra view
     */
    @JvmName("yximmprftiujwsea")
    public suspend fun viewDefinition(`value`: Output<String>) {
        this.viewDefinition = value
    }

    /**
     * @param value Name of the Cosmos DB Cassandra view
     */
    @JvmName("asdmiayojpdkjwpx")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value View Definition of the Cosmos DB Cassandra view
     */
    @JvmName("klniqbaokquvjwgr")
    public suspend fun viewDefinition(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.viewDefinition = mapped
    }

    internal fun build(): CassandraViewResourceArgs = CassandraViewResourceArgs(
        id = id ?: throw PulumiNullFieldException("id"),
        viewDefinition = viewDefinition ?: throw PulumiNullFieldException("viewDefinition"),
    )
}
