@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.inputs

import com.pulumi.azurenative.documentdb.inputs.GetCassandraDataCenterPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property clusterName Managed Cassandra cluster name.
 * @property dataCenterName Data center name in a managed Cassandra cluster.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetCassandraDataCenterPlainArgs(
    public val clusterName: String,
    public val dataCenterName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.inputs.GetCassandraDataCenterPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.inputs.GetCassandraDataCenterPlainArgs =
        com.pulumi.azurenative.documentdb.inputs.GetCassandraDataCenterPlainArgs.builder()
            .clusterName(clusterName.let({ args0 -> args0 }))
            .dataCenterName(dataCenterName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCassandraDataCenterPlainArgs].
 */
@PulumiTagMarker
public class GetCassandraDataCenterPlainArgsBuilder internal constructor() {
    private var clusterName: String? = null

    private var dataCenterName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Managed Cassandra cluster name.
     */
    @JvmName("lhaijytkqduyydiq")
    public suspend fun clusterName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.clusterName = mapped
    }

    /**
     * @param value Data center name in a managed Cassandra cluster.
     */
    @JvmName("duhrfexdbgwcnhct")
    public suspend fun dataCenterName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.dataCenterName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("mogtaeuboxrfmbsq")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetCassandraDataCenterPlainArgs = GetCassandraDataCenterPlainArgs(
        clusterName = clusterName ?: throw PulumiNullFieldException("clusterName"),
        dataCenterName = dataCenterName ?: throw PulumiNullFieldException("dataCenterName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
