@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.inputs

import com.pulumi.azurenative.documentdb.inputs.GetMongoDBResourceMongoUserDefinitionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName Cosmos DB database account name.
 * @property mongoUserDefinitionId The ID for the User Definition {dbName.userName}.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetMongoDBResourceMongoUserDefinitionPlainArgs(
    public val accountName: String,
    public val mongoUserDefinitionId: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.documentdb.inputs.GetMongoDBResourceMongoUserDefinitionPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.documentdb.inputs.GetMongoDBResourceMongoUserDefinitionPlainArgs =
        com.pulumi.azurenative.documentdb.inputs.GetMongoDBResourceMongoUserDefinitionPlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .mongoUserDefinitionId(mongoUserDefinitionId.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetMongoDBResourceMongoUserDefinitionPlainArgs].
 */
@PulumiTagMarker
public class GetMongoDBResourceMongoUserDefinitionPlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var mongoUserDefinitionId: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Cosmos DB database account name.
     */
    @JvmName("gunbfandcyagxvxy")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value The ID for the User Definition {dbName.userName}.
     */
    @JvmName("lcvcwqbnqbaegmqa")
    public suspend fun mongoUserDefinitionId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.mongoUserDefinitionId = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("qagpvmvvcoepkjpr")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetMongoDBResourceMongoUserDefinitionPlainArgs =
        GetMongoDBResourceMongoUserDefinitionPlainArgs(
            accountName = accountName ?: throw PulumiNullFieldException("accountName"),
            mongoUserDefinitionId = mongoUserDefinitionId ?: throw
                PulumiNullFieldException("mongoUserDefinitionId"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
