@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.inputs

import com.pulumi.azurenative.documentdb.inputs.GetSqlResourceSqlContainerPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName Cosmos DB database account name.
 * @property containerName Cosmos DB container name.
 * @property databaseName Cosmos DB database name.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetSqlResourceSqlContainerPlainArgs(
    public val accountName: String,
    public val containerName: String,
    public val databaseName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.inputs.GetSqlResourceSqlContainerPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.documentdb.inputs.GetSqlResourceSqlContainerPlainArgs =
        com.pulumi.azurenative.documentdb.inputs.GetSqlResourceSqlContainerPlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .containerName(containerName.let({ args0 -> args0 }))
            .databaseName(databaseName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSqlResourceSqlContainerPlainArgs].
 */
@PulumiTagMarker
public class GetSqlResourceSqlContainerPlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var containerName: String? = null

    private var databaseName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Cosmos DB database account name.
     */
    @JvmName("vlshshpepyuumqlu")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value Cosmos DB container name.
     */
    @JvmName("rgmjyqxbnnsanjpd")
    public suspend fun containerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.containerName = mapped
    }

    /**
     * @param value Cosmos DB database name.
     */
    @JvmName("ivjsmfhooresxaoi")
    public suspend fun databaseName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.databaseName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("mywfvhdrmjtoygoc")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetSqlResourceSqlContainerPlainArgs = GetSqlResourceSqlContainerPlainArgs(
        accountName = accountName ?: throw PulumiNullFieldException("accountName"),
        containerName = containerName ?: throw PulumiNullFieldException("containerName"),
        databaseName = databaseName ?: throw PulumiNullFieldException("databaseName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
