@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.inputs

import com.pulumi.azurenative.documentdb.inputs.GetSqlResourceSqlUserDefinedFunctionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName Cosmos DB database account name.
 * @property containerName Cosmos DB container name.
 * @property databaseName Cosmos DB database name.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property userDefinedFunctionName Cosmos DB userDefinedFunction name.
 */
public data class GetSqlResourceSqlUserDefinedFunctionPlainArgs(
    public val accountName: String,
    public val containerName: String,
    public val databaseName: String,
    public val resourceGroupName: String,
    public val userDefinedFunctionName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.documentdb.inputs.GetSqlResourceSqlUserDefinedFunctionPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.documentdb.inputs.GetSqlResourceSqlUserDefinedFunctionPlainArgs =
        com.pulumi.azurenative.documentdb.inputs.GetSqlResourceSqlUserDefinedFunctionPlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .containerName(containerName.let({ args0 -> args0 }))
            .databaseName(databaseName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .userDefinedFunctionName(userDefinedFunctionName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSqlResourceSqlUserDefinedFunctionPlainArgs].
 */
@PulumiTagMarker
public class GetSqlResourceSqlUserDefinedFunctionPlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var containerName: String? = null

    private var databaseName: String? = null

    private var resourceGroupName: String? = null

    private var userDefinedFunctionName: String? = null

    /**
     * @param value Cosmos DB database account name.
     */
    @JvmName("slvkyovucuvmkevh")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value Cosmos DB container name.
     */
    @JvmName("cfiiuyjlfmqimies")
    public suspend fun containerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.containerName = mapped
    }

    /**
     * @param value Cosmos DB database name.
     */
    @JvmName("mfclyjjultkrqcwn")
    public suspend fun databaseName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.databaseName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("qlufhxmvjhdflfta")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Cosmos DB userDefinedFunction name.
     */
    @JvmName("dpgbbbytuqbhgkfp")
    public suspend fun userDefinedFunctionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.userDefinedFunctionName = mapped
    }

    internal fun build(): GetSqlResourceSqlUserDefinedFunctionPlainArgs =
        GetSqlResourceSqlUserDefinedFunctionPlainArgs(
            accountName = accountName ?: throw PulumiNullFieldException("accountName"),
            containerName = containerName ?: throw PulumiNullFieldException("containerName"),
            databaseName = databaseName ?: throw PulumiNullFieldException("databaseName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            userDefinedFunctionName = userDefinedFunctionName ?: throw
                PulumiNullFieldException("userDefinedFunctionName"),
        )
}
