@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.inputs

import com.pulumi.azurenative.documentdb.inputs.GraphResourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Cosmos DB Graph resource object
 * @property id Name of the Cosmos DB Graph
 */
public data class GraphResourceArgs(
    public val id: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.inputs.GraphResourceArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.inputs.GraphResourceArgs =
        com.pulumi.azurenative.documentdb.inputs.GraphResourceArgs.builder()
            .id(id.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GraphResourceArgs].
 */
@PulumiTagMarker
public class GraphResourceArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    /**
     * @param value Name of the Cosmos DB Graph
     */
    @JvmName("artbflqaimkbbyae")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Name of the Cosmos DB Graph
     */
    @JvmName("spuundaivbnbyeed")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): GraphResourceArgs = GraphResourceArgs(
        id = id ?: throw PulumiNullFieldException("id"),
    )
}
