@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.inputs

import com.pulumi.azurenative.documentdb.inputs.IndexingPolicyArgs.builder
import com.pulumi.azurenative.documentdb.kotlin.enums.IndexingMode
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Cosmos DB indexing policy
 * @property automatic Indicates if the indexing policy is automatic
 * @property compositeIndexes List of composite path list
 * @property excludedPaths List of paths to exclude from indexing
 * @property includedPaths List of paths to include in the indexing
 * @property indexingMode Indicates the indexing mode.
 * @property spatialIndexes List of spatial specifics
 */
public data class IndexingPolicyArgs(
    public val automatic: Output<Boolean>? = null,
    public val compositeIndexes: Output<List<List<CompositePathArgs>>>? = null,
    public val excludedPaths: Output<List<ExcludedPathArgs>>? = null,
    public val includedPaths: Output<List<IncludedPathArgs>>? = null,
    public val indexingMode: Output<Either<String, IndexingMode>>? = null,
    public val spatialIndexes: Output<List<SpatialSpecArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.inputs.IndexingPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.inputs.IndexingPolicyArgs =
        com.pulumi.azurenative.documentdb.inputs.IndexingPolicyArgs.builder()
            .automatic(automatic?.applyValue({ args0 -> args0 }))
            .compositeIndexes(
                compositeIndexes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.map({ args0 ->
                            args0.let({ args0 -> args0.toJava() })
                        })
                    })
                }),
            )
            .excludedPaths(
                excludedPaths?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .includedPaths(
                includedPaths?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .indexingMode(
                indexingMode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .spatialIndexes(
                spatialIndexes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [IndexingPolicyArgs].
 */
@PulumiTagMarker
public class IndexingPolicyArgsBuilder internal constructor() {
    private var automatic: Output<Boolean>? = null

    private var compositeIndexes: Output<List<List<CompositePathArgs>>>? = null

    private var excludedPaths: Output<List<ExcludedPathArgs>>? = null

    private var includedPaths: Output<List<IncludedPathArgs>>? = null

    private var indexingMode: Output<Either<String, IndexingMode>>? = null

    private var spatialIndexes: Output<List<SpatialSpecArgs>>? = null

    /**
     * @param value Indicates if the indexing policy is automatic
     */
    @JvmName("uvpcyipgeyglukfy")
    public suspend fun automatic(`value`: Output<Boolean>) {
        this.automatic = value
    }

    /**
     * @param value List of composite path list
     */
    @JvmName("qavmyjkogreimpie")
    public suspend fun compositeIndexes(`value`: Output<List<List<CompositePathArgs>>>) {
        this.compositeIndexes = value
    }

    @JvmName("awvkxfysyvwcwysh")
    public suspend fun compositeIndexes(vararg values: Output<List<CompositePathArgs>>) {
        this.compositeIndexes = Output.all(values.asList())
    }

    /**
     * @param values List of composite path list
     */
    @JvmName("updsyjmhknicmkcg")
    public suspend fun compositeIndexes(values: List<Output<List<CompositePathArgs>>>) {
        this.compositeIndexes = Output.all(values)
    }

    /**
     * @param value List of paths to exclude from indexing
     */
    @JvmName("opskacdrtgkajijj")
    public suspend fun excludedPaths(`value`: Output<List<ExcludedPathArgs>>) {
        this.excludedPaths = value
    }

    @JvmName("vwgmrrglytoayoox")
    public suspend fun excludedPaths(vararg values: Output<ExcludedPathArgs>) {
        this.excludedPaths = Output.all(values.asList())
    }

    /**
     * @param values List of paths to exclude from indexing
     */
    @JvmName("kicaqqknfcajfalp")
    public suspend fun excludedPaths(values: List<Output<ExcludedPathArgs>>) {
        this.excludedPaths = Output.all(values)
    }

    /**
     * @param value List of paths to include in the indexing
     */
    @JvmName("uxyphlfvwfhcywlo")
    public suspend fun includedPaths(`value`: Output<List<IncludedPathArgs>>) {
        this.includedPaths = value
    }

    @JvmName("eyafwroqhwsjtsbw")
    public suspend fun includedPaths(vararg values: Output<IncludedPathArgs>) {
        this.includedPaths = Output.all(values.asList())
    }

    /**
     * @param values List of paths to include in the indexing
     */
    @JvmName("lxgnkkolwlmdgkgu")
    public suspend fun includedPaths(values: List<Output<IncludedPathArgs>>) {
        this.includedPaths = Output.all(values)
    }

    /**
     * @param value Indicates the indexing mode.
     */
    @JvmName("pkcsmsvxaqyrxxiw")
    public suspend fun indexingMode(`value`: Output<Either<String, IndexingMode>>) {
        this.indexingMode = value
    }

    /**
     * @param value List of spatial specifics
     */
    @JvmName("vxxmqgsepuujgbkm")
    public suspend fun spatialIndexes(`value`: Output<List<SpatialSpecArgs>>) {
        this.spatialIndexes = value
    }

    @JvmName("rmsgfvxeantjuyay")
    public suspend fun spatialIndexes(vararg values: Output<SpatialSpecArgs>) {
        this.spatialIndexes = Output.all(values.asList())
    }

    /**
     * @param values List of spatial specifics
     */
    @JvmName("noqpanhvbyksfitg")
    public suspend fun spatialIndexes(values: List<Output<SpatialSpecArgs>>) {
        this.spatialIndexes = Output.all(values)
    }

    /**
     * @param value Indicates if the indexing policy is automatic
     */
    @JvmName("gsywrrpbchjqousk")
    public suspend fun automatic(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.automatic = mapped
    }

    /**
     * @param value List of composite path list
     */
    @JvmName("gnuaulwhfhwgqill")
    public suspend fun compositeIndexes(`value`: List<List<CompositePathArgs>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.compositeIndexes = mapped
    }

    /**
     * @param values List of composite path list
     */
    @JvmName("nlfevovyxmdvkrty")
    public suspend fun compositeIndexes(vararg values: List<CompositePathArgs>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.compositeIndexes = mapped
    }

    /**
     * @param value List of paths to exclude from indexing
     */
    @JvmName("nqvtusnrhketnplp")
    public suspend fun excludedPaths(`value`: List<ExcludedPathArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.excludedPaths = mapped
    }

    /**
     * @param argument List of paths to exclude from indexing
     */
    @JvmName("hotgbsrmltrhbvdr")
    public suspend fun excludedPaths(argument: List<suspend ExcludedPathArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ExcludedPathArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.excludedPaths = mapped
    }

    /**
     * @param argument List of paths to exclude from indexing
     */
    @JvmName("aksnialbeikrvohn")
    public suspend fun excludedPaths(vararg argument: suspend ExcludedPathArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ExcludedPathArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.excludedPaths = mapped
    }

    /**
     * @param argument List of paths to exclude from indexing
     */
    @JvmName("fvptqbwhfmuhkddx")
    public suspend fun excludedPaths(argument: suspend ExcludedPathArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ExcludedPathArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.excludedPaths = mapped
    }

    /**
     * @param values List of paths to exclude from indexing
     */
    @JvmName("ksnyptrsvbkiemol")
    public suspend fun excludedPaths(vararg values: ExcludedPathArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.excludedPaths = mapped
    }

    /**
     * @param value List of paths to include in the indexing
     */
    @JvmName("rthkvbgmtfbpposf")
    public suspend fun includedPaths(`value`: List<IncludedPathArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.includedPaths = mapped
    }

    /**
     * @param argument List of paths to include in the indexing
     */
    @JvmName("qosmahsvevnqrxla")
    public suspend fun includedPaths(argument: List<suspend IncludedPathArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            IncludedPathArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.includedPaths = mapped
    }

    /**
     * @param argument List of paths to include in the indexing
     */
    @JvmName("ielsynkxkrpwlkhm")
    public suspend fun includedPaths(vararg argument: suspend IncludedPathArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            IncludedPathArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.includedPaths = mapped
    }

    /**
     * @param argument List of paths to include in the indexing
     */
    @JvmName("iiixtacqkmjrovir")
    public suspend fun includedPaths(argument: suspend IncludedPathArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(IncludedPathArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.includedPaths = mapped
    }

    /**
     * @param values List of paths to include in the indexing
     */
    @JvmName("xlqvfsebqekgpaxo")
    public suspend fun includedPaths(vararg values: IncludedPathArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.includedPaths = mapped
    }

    /**
     * @param value Indicates the indexing mode.
     */
    @JvmName("serwovhpcewfqyxa")
    public suspend fun indexingMode(`value`: Either<String, IndexingMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.indexingMode = mapped
    }

    /**
     * @param value Indicates the indexing mode.
     */
    @JvmName("wigfcgyywhyatkhh")
    public fun indexingMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, IndexingMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.indexingMode = mapped
    }

    /**
     * @param value Indicates the indexing mode.
     */
    @JvmName("xwdrgwmmdnunaowb")
    public fun indexingMode(`value`: IndexingMode) {
        val toBeMapped = Either.ofRight<String, IndexingMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.indexingMode = mapped
    }

    /**
     * @param value List of spatial specifics
     */
    @JvmName("sonrotxumnvtdojw")
    public suspend fun spatialIndexes(`value`: List<SpatialSpecArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spatialIndexes = mapped
    }

    /**
     * @param argument List of spatial specifics
     */
    @JvmName("atikmrfqvkvlseet")
    public suspend fun spatialIndexes(argument: List<suspend SpatialSpecArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { SpatialSpecArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.spatialIndexes = mapped
    }

    /**
     * @param argument List of spatial specifics
     */
    @JvmName("vfremqrgubrjbgbn")
    public suspend fun spatialIndexes(vararg argument: suspend SpatialSpecArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { SpatialSpecArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.spatialIndexes = mapped
    }

    /**
     * @param argument List of spatial specifics
     */
    @JvmName("fctavacxihdqfkrb")
    public suspend fun spatialIndexes(argument: suspend SpatialSpecArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SpatialSpecArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.spatialIndexes = mapped
    }

    /**
     * @param values List of spatial specifics
     */
    @JvmName("lnuudurwkrurcrnf")
    public suspend fun spatialIndexes(vararg values: SpatialSpecArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.spatialIndexes = mapped
    }

    internal fun build(): IndexingPolicyArgs = IndexingPolicyArgs(
        automatic = automatic,
        compositeIndexes = compositeIndexes,
        excludedPaths = excludedPaths,
        includedPaths = includedPaths,
        indexingMode = indexingMode,
        spatialIndexes = spatialIndexes,
    )
}
