@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.inputs

import com.pulumi.azurenative.documentdb.inputs.MongoIndexArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Cosmos DB MongoDB collection index key
 * @property key Cosmos DB MongoDB collection index keys
 * @property options Cosmos DB MongoDB collection index key options
 */
public data class MongoIndexArgs(
    public val key: Output<MongoIndexKeysArgs>? = null,
    public val options: Output<MongoIndexOptionsArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.inputs.MongoIndexArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.inputs.MongoIndexArgs =
        com.pulumi.azurenative.documentdb.inputs.MongoIndexArgs.builder()
            .key(key?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .options(options?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [MongoIndexArgs].
 */
@PulumiTagMarker
public class MongoIndexArgsBuilder internal constructor() {
    private var key: Output<MongoIndexKeysArgs>? = null

    private var options: Output<MongoIndexOptionsArgs>? = null

    /**
     * @param value Cosmos DB MongoDB collection index keys
     */
    @JvmName("rjvyxbljcyqdfbth")
    public suspend fun key(`value`: Output<MongoIndexKeysArgs>) {
        this.key = value
    }

    /**
     * @param value Cosmos DB MongoDB collection index key options
     */
    @JvmName("qaymkpuppklbibnt")
    public suspend fun options(`value`: Output<MongoIndexOptionsArgs>) {
        this.options = value
    }

    /**
     * @param value Cosmos DB MongoDB collection index keys
     */
    @JvmName("txffaufkyiqphacw")
    public suspend fun key(`value`: MongoIndexKeysArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param argument Cosmos DB MongoDB collection index keys
     */
    @JvmName("qsddxpwapqwvwgeo")
    public suspend fun key(argument: suspend MongoIndexKeysArgsBuilder.() -> Unit) {
        val toBeMapped = MongoIndexKeysArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.key = mapped
    }

    /**
     * @param value Cosmos DB MongoDB collection index key options
     */
    @JvmName("asxhktcaltpaldsm")
    public suspend fun options(`value`: MongoIndexOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.options = mapped
    }

    /**
     * @param argument Cosmos DB MongoDB collection index key options
     */
    @JvmName("hioqjqmqwtnxqaxv")
    public suspend fun options(argument: suspend MongoIndexOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = MongoIndexOptionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.options = mapped
    }

    internal fun build(): MongoIndexArgs = MongoIndexArgs(
        key = key,
        options = options,
    )
}
