@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.inputs

import com.pulumi.azurenative.documentdb.inputs.PrivilegeResourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * An Azure Cosmos DB Mongo DB Resource.
 * @property collection The collection name the role is applied.
 * @property db The database name the role is applied.
 */
public data class PrivilegeResourceArgs(
    public val collection: Output<String>? = null,
    public val db: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.inputs.PrivilegeResourceArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.inputs.PrivilegeResourceArgs =
        com.pulumi.azurenative.documentdb.inputs.PrivilegeResourceArgs.builder()
            .collection(collection?.applyValue({ args0 -> args0 }))
            .db(db?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PrivilegeResourceArgs].
 */
@PulumiTagMarker
public class PrivilegeResourceArgsBuilder internal constructor() {
    private var collection: Output<String>? = null

    private var db: Output<String>? = null

    /**
     * @param value The collection name the role is applied.
     */
    @JvmName("wrpavutkbwirjijq")
    public suspend fun collection(`value`: Output<String>) {
        this.collection = value
    }

    /**
     * @param value The database name the role is applied.
     */
    @JvmName("xncohgjlhxdjxcif")
    public suspend fun db(`value`: Output<String>) {
        this.db = value
    }

    /**
     * @param value The collection name the role is applied.
     */
    @JvmName("hcpmfqblaeqarqbh")
    public suspend fun collection(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.collection = mapped
    }

    /**
     * @param value The database name the role is applied.
     */
    @JvmName("cjyeucwnvgnnhwjx")
    public suspend fun db(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.db = mapped
    }

    internal fun build(): PrivilegeResourceArgs = PrivilegeResourceArgs(
        collection = collection,
        db = db,
    )
}
