@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.inputs

import com.pulumi.azurenative.documentdb.inputs.SeedNodeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property ipAddress IP address of this seed node.
 */
public data class SeedNodeArgs(
    public val ipAddress: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.inputs.SeedNodeArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.inputs.SeedNodeArgs =
        com.pulumi.azurenative.documentdb.inputs.SeedNodeArgs.builder()
            .ipAddress(ipAddress?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SeedNodeArgs].
 */
@PulumiTagMarker
public class SeedNodeArgsBuilder internal constructor() {
    private var ipAddress: Output<String>? = null

    /**
     * @param value IP address of this seed node.
     */
    @JvmName("msbxddhjnjpgbwjk")
    public suspend fun ipAddress(`value`: Output<String>) {
        this.ipAddress = value
    }

    /**
     * @param value IP address of this seed node.
     */
    @JvmName("gyysjiqssjxyiikk")
    public suspend fun ipAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipAddress = mapped
    }

    internal fun build(): SeedNodeArgs = SeedNodeArgs(
        ipAddress = ipAddress,
    )
}
