@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.inputs

import com.pulumi.azurenative.documentdb.inputs.SpatialSpecArgs.builder
import com.pulumi.azurenative.documentdb.kotlin.enums.SpatialType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property path The path for which the indexing behavior applies to. Index paths typically start with root and end with wildcard (/path/*)
 * @property types List of path's spatial type
 * */
 */
public data class SpatialSpecArgs(
    public val path: Output<String>? = null,
    public val types: Output<List<Either<String, SpatialType>>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.inputs.SpatialSpecArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.inputs.SpatialSpecArgs =
        com.pulumi.azurenative.documentdb.inputs.SpatialSpecArgs.builder()
            .path(path?.applyValue({ args0 -> args0 }))
            .types(
                types?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 -> args0 }, { args0 ->
                            args0.let({ args0 -> args0.toJava() })
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [SpatialSpecArgs].
 */
@PulumiTagMarker
public class SpatialSpecArgsBuilder internal constructor() {
    private var path: Output<String>? = null

    private var types: Output<List<Either<String, SpatialType>>>? = null

    /**
     * @param value The path for which the indexing behavior applies to. Index paths typically start with root and end with wildcard (/path/*)
     * */
     */
    @JvmName("xmsjeifdexdnlvwl")
    public suspend fun path(`value`: Output<String>) {
        this.path = value
    }

    /**
     * @param value List of path's spatial type
     */
    @JvmName("tiffaoxantyaxtun")
    public suspend fun types(`value`: Output<List<Either<String, SpatialType>>>) {
        this.types = value
    }

    @JvmName("iyfclyyuslfytmvw")
    public suspend fun types(vararg values: Output<Either<String, SpatialType>>) {
        this.types = Output.all(values.asList())
    }

    /**
     * @param values List of path's spatial type
     */
    @JvmName("evbxncfanglsuovr")
    public suspend fun types(values: List<Output<Either<String, SpatialType>>>) {
        this.types = Output.all(values)
    }

    /**
     * @param value The path for which the indexing behavior applies to. Index paths typically start with root and end with wildcard (/path/*)
     * */
     */
    @JvmName("mkwdjlrlkcmgdmcu")
    public suspend fun path(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.path = mapped
    }

    /**
     * @param value List of path's spatial type
     */
    @JvmName("qrpahhboiejqvnvo")
    public suspend fun types(`value`: List<Either<String, SpatialType>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.types = mapped
    }

    /**
     * @param values List of path's spatial type
     */
    @JvmName("anovexbxccrcjhus")
    public suspend fun types(vararg values: Either<String, SpatialType>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.types = mapped
    }

    internal fun build(): SpatialSpecArgs = SpatialSpecArgs(
        path = path,
        types = types,
    )
}
