@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Cosmos DB Cassandra table cluster key
 * @property name Name of the Cosmos DB Cassandra table cluster key
 * @property orderBy Order of the Cosmos DB Cassandra table cluster key, only support "Asc" and "Desc"
 */
public data class ClusterKeyResponse(
    public val name: String? = null,
    public val orderBy: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.documentdb.outputs.ClusterKeyResponse):
            ClusterKeyResponse = ClusterKeyResponse(
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            orderBy = javaType.orderBy().map({ args0 -> args0 }).orElse(null),
        )
    }
}
