@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Cosmos DB Cassandra table column
 * @property name Name of the Cosmos DB Cassandra table column
 * @property type Type of the Cosmos DB Cassandra table column
 */
public data class ColumnResponse(
    public val name: String? = null,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.documentdb.outputs.ColumnResponse):
            ColumnResponse = ColumnResponse(
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
