@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Properties of a managed Cassandra data center.
 * @property authenticationMethodLdapProperties Ldap authentication method properties. This feature is in preview.
 * @property availabilityZone If the data center has Availability Zone support, apply it to the Virtual Machine ScaleSet that host the cassandra data center virtual machines.
 * @property backupStorageCustomerKeyUri Indicates the Key Uri of the customer key to use for encryption of the backup storage account.
 * @property base64EncodedCassandraYamlFragment A fragment of a cassandra.yaml configuration file to be included in the cassandra.yaml for all nodes in this data center. The fragment should be Base64 encoded, and only a subset of keys are allowed.
 * @property dataCenterLocation The region this data center should be created in.
 * @property deallocated Whether the data center has been deallocated.
 * @property delegatedSubnetId Resource id of a subnet the nodes in this data center should have their network interfaces connected to. The subnet must be in the same region specified in 'dataCenterLocation' and must be able to route to the subnet specified in the cluster's 'delegatedManagementSubnetId' property. This resource id will be of the form '/subscriptions/<subscription id>/resourceGroups/<resource group>/providers/Microsoft.Network/virtualNetworks/<virtual network>/subnets/<subnet>'.
 * @property diskCapacity Number of disks attached to each node. Default is 4.
 * @property diskSku Disk SKU used for data centers. Default value is P30.
 * @property managedDiskCustomerKeyUri Key uri to use for encryption of managed disks. Ensure the system assigned identity of the cluster has been assigned appropriate permissions(key get/wrap/unwrap permissions) on the key.
 * @property nodeCount The number of nodes the data center should have. This is the desired number. After it is set, it may take some time for the data center to be scaled to match. To monitor the number of nodes and their status, use the fetchNodeStatus method on the cluster.
 * @property provisionError Error related to resource provisioning.
 * @property provisioningState The status of the resource at the time the operation was called.
 * @property seedNodes IP addresses for seed nodes in this data center. This is for reference. Generally you will want to use the seedNodes property on the cluster, which aggregates the seed nodes from all data centers in the cluster.
 * @property sku Virtual Machine SKU used for data centers. Default value is Standard_DS14_v2
 */
public data class DataCenterResourceResponseProperties(
    public val authenticationMethodLdapProperties: AuthenticationMethodLdapPropertiesResponse? = null,
    public val availabilityZone: Boolean? = null,
    public val backupStorageCustomerKeyUri: String? = null,
    public val base64EncodedCassandraYamlFragment: String? = null,
    public val dataCenterLocation: String? = null,
    public val deallocated: Boolean? = null,
    public val delegatedSubnetId: String? = null,
    public val diskCapacity: Int? = null,
    public val diskSku: String? = null,
    public val managedDiskCustomerKeyUri: String? = null,
    public val nodeCount: Int? = null,
    public val provisionError: CassandraErrorResponse? = null,
    public val provisioningState: String? = null,
    public val seedNodes: List<SeedNodeResponse>,
    public val sku: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.documentdb.outputs.DataCenterResourceResponseProperties):
            DataCenterResourceResponseProperties = DataCenterResourceResponseProperties(
            authenticationMethodLdapProperties = javaType.authenticationMethodLdapProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.documentdb.kotlin.outputs.AuthenticationMethodLdapPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            availabilityZone = javaType.availabilityZone().map({ args0 -> args0 }).orElse(null),
            backupStorageCustomerKeyUri = javaType.backupStorageCustomerKeyUri().map({ args0 ->
                args0
            }).orElse(null),
            base64EncodedCassandraYamlFragment = javaType.base64EncodedCassandraYamlFragment().map({ args0 ->
                args0
            }).orElse(null),
            dataCenterLocation = javaType.dataCenterLocation().map({ args0 -> args0 }).orElse(null),
            deallocated = javaType.deallocated().map({ args0 -> args0 }).orElse(null),
            delegatedSubnetId = javaType.delegatedSubnetId().map({ args0 -> args0 }).orElse(null),
            diskCapacity = javaType.diskCapacity().map({ args0 -> args0 }).orElse(null),
            diskSku = javaType.diskSku().map({ args0 -> args0 }).orElse(null),
            managedDiskCustomerKeyUri = javaType.managedDiskCustomerKeyUri().map({ args0 ->
                args0
            }).orElse(null),
            nodeCount = javaType.nodeCount().map({ args0 -> args0 }).orElse(null),
            provisionError = javaType.provisionError().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.documentdb.kotlin.outputs.CassandraErrorResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            provisioningState = javaType.provisioningState().map({ args0 -> args0 }).orElse(null),
            seedNodes = javaType.seedNodes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.documentdb.kotlin.outputs.SeedNodeResponse.Companion.toKotlin(args0)
                })
            }),
            sku = javaType.sku().map({ args0 -> args0 }).orElse(null),
        )
    }
}
