@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Specific Databases to restore.
 * @property collectionNames The names of the collections available for restore.
 * @property databaseName The name of the database available for restore.
 */
public data class DatabaseRestoreResourceResponse(
    public val collectionNames: List<String>? = null,
    public val databaseName: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.documentdb.outputs.DatabaseRestoreResourceResponse):
            DatabaseRestoreResourceResponse = DatabaseRestoreResourceResponse(
            collectionNames = javaType.collectionNames().map({ args0 -> args0 }),
            databaseName = javaType.databaseName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
