@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * An Azure Cosmos DB Throughputpool Account
 * @property accountInstanceId The instance id of global database account in the throughputPool.
 * @property accountLocation The location of  global database account in the throughputPool.
 * @property accountResourceIdentifier The resource identifier of global database account in the throughputPool.
 * @property id Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
 * @property name The name of the resource
 * @property provisioningState A provisioning state of the ThroughputPool Account.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetThroughputPoolAccountResult(
    public val accountInstanceId: String,
    public val accountLocation: String? = null,
    public val accountResourceIdentifier: String? = null,
    public val id: String,
    public val name: String,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.documentdb.outputs.GetThroughputPoolAccountResult):
            GetThroughputPoolAccountResult = GetThroughputPoolAccountResult(
            accountInstanceId = javaType.accountInstanceId(),
            accountLocation = javaType.accountLocation().map({ args0 -> args0 }).orElse(null),
            accountResourceIdentifier = javaType.accountResourceIdentifier().map({ args0 ->
                args0
            }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.documentdb.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
