@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * An Azure Cosmos DB Throughputpool.
 * @property id Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
 * @property location The geo-location where the resource lives
 * @property maxThroughput Value for throughput to be shared among CosmosDB resources in the pool.
 * @property name The name of the resource
 * @property provisioningState A provisioning state of the ThroughputPool.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetThroughputPoolResult(
    public val id: String,
    public val location: String,
    public val maxThroughput: Int? = null,
    public val name: String,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.documentdb.outputs.GetThroughputPoolResult):
            GetThroughputPoolResult = GetThroughputPoolResult(
            id = javaType.id(),
            location = javaType.location(),
            maxThroughput = javaType.maxThroughput().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.documentdb.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
