@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The set of data plane operations permitted through this Role Definition.
 * @property dataActions An array of data actions that are allowed.
 * @property notDataActions An array of data actions that are denied.
 */
public data class PermissionResponse(
    public val dataActions: List<String>? = null,
    public val notDataActions: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.documentdb.outputs.PermissionResponse):
            PermissionResponse = PermissionResponse(
            dataActions = javaType.dataActions().map({ args0 -> args0 }),
            notDataActions = javaType.notDataActions().map({ args0 -> args0 }),
        )
    }
}
