@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The set of data plane operations permitted through this Role Definition.
 * @property actions An array of actions that are allowed.
 * @property resource An Azure Cosmos DB Mongo DB Resource.
 */
public data class PrivilegeResponse(
    public val actions: List<String>? = null,
    public val resource: PrivilegeResponseResource? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.documentdb.outputs.PrivilegeResponse):
            PrivilegeResponse = PrivilegeResponse(
            actions = javaType.actions().map({ args0 -> args0 }),
            resource = javaType.resource().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.documentdb.kotlin.outputs.PrivilegeResponseResource.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
