@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Virtual Network ACL Rule object
 * @property id Resource ID of a subnet, for example: /subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}.
 * @property ignoreMissingVNetServiceEndpoint Create firewall rule before the virtual network has vnet service endpoint enabled.
 */
public data class VirtualNetworkRuleResponse(
    public val id: String? = null,
    public val ignoreMissingVNetServiceEndpoint: Boolean? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.documentdb.outputs.VirtualNetworkRuleResponse):
            VirtualNetworkRuleResponse = VirtualNetworkRuleResponse(
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            ignoreMissingVNetServiceEndpoint = javaType.ignoreMissingVNetServiceEndpoint().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
