@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.domainregistration.kotlin

import com.pulumi.azurenative.domainregistration.DomainArgs.builder
import com.pulumi.azurenative.domainregistration.kotlin.enums.DnsType
import com.pulumi.azurenative.domainregistration.kotlin.inputs.ContactArgs
import com.pulumi.azurenative.domainregistration.kotlin.inputs.ContactArgsBuilder
import com.pulumi.azurenative.domainregistration.kotlin.inputs.DomainPurchaseConsentArgs
import com.pulumi.azurenative.domainregistration.kotlin.inputs.DomainPurchaseConsentArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Information about a domain.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2020-10-01.
 * Other available API versions: 2020-10-01, 2023-01-01.
 * ## Example Usage
 * ### Create App Service Domain
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var domain = new AzureNative.DomainRegistration.Domain("domain", new()
 *     {
 *         AuthCode = "exampleAuthCode",
 *         AutoRenew = true,
 *         Consent = new AzureNative.DomainRegistration.Inputs.DomainPurchaseConsentArgs
 *         {
 *             AgreedAt = "2021-09-10T19:30:53Z",
 *             AgreedBy = "192.0.2.1",
 *             AgreementKeys = new[]
 *             {
 *                 "agreementKey1",
 *             },
 *         },
 *         ContactAdmin = new AzureNative.DomainRegistration.Inputs.ContactArgs
 *         {
 *             AddressMailing = new AzureNative.DomainRegistration.Inputs.AddressArgs
 *             {
 *                 Address1 = "3400 State St",
 *                 City = "Chicago",
 *                 Country = "United States",
 *                 PostalCode = "67098",
 *                 State = "IL",
 *             },
 *             Email = "admin@email.com",
 *             Fax = "1-245-534-2242",
 *             JobTitle = "Admin",
 *             NameFirst = "John",
 *             NameLast = "Doe",
 *             NameMiddle = "",
 *             Organization = "Microsoft Inc.",
 *             Phone = "1-245-534-2242",
 *         },
 *         ContactBilling = new AzureNative.DomainRegistration.Inputs.ContactArgs
 *         {
 *             AddressMailing = new AzureNative.DomainRegistration.Inputs.AddressArgs
 *             {
 *                 Address1 = "3400 State St",
 *                 City = "Chicago",
 *                 Country = "United States",
 *                 PostalCode = "67098",
 *                 State = "IL",
 *             },
 *             Email = "billing@email.com",
 *             Fax = "1-245-534-2242",
 *             JobTitle = "Billing",
 *             NameFirst = "John",
 *             NameLast = "Doe",
 *             NameMiddle = "",
 *             Organization = "Microsoft Inc.",
 *             Phone = "1-245-534-2242",
 *         },
 *         ContactRegistrant = new AzureNative.DomainRegistration.Inputs.ContactArgs
 *         {
 *             AddressMailing = new AzureNative.DomainRegistration.Inputs.AddressArgs
 *             {
 *                 Address1 = "3400 State St",
 *                 City = "Chicago",
 *                 Country = "United States",
 *                 PostalCode = "67098",
 *                 State = "IL",
 *             },
 *             Email = "registrant@email.com",
 *             Fax = "1-245-534-2242",
 *             JobTitle = "Registrant",
 *             NameFirst = "John",
 *             NameLast = "Doe",
 *             NameMiddle = "",
 *             Organization = "Microsoft Inc.",
 *             Phone = "1-245-534-2242",
 *         },
 *         ContactTech = new AzureNative.DomainRegistration.Inputs.ContactArgs
 *         {
 *             AddressMailing = new AzureNative.DomainRegistration.Inputs.AddressArgs
 *             {
 *                 Address1 = "3400 State St",
 *                 City = "Chicago",
 *                 Country = "United States",
 *                 PostalCode = "67098",
 *                 State = "IL",
 *             },
 *             Email = "tech@email.com",
 *             Fax = "1-245-534-2242",
 *             JobTitle = "Tech",
 *             NameFirst = "John",
 *             NameLast = "Doe",
 *             NameMiddle = "",
 *             Organization = "Microsoft Inc.",
 *             Phone = "1-245-534-2242",
 *         },
 *         DnsType = AzureNative.DomainRegistration.DnsType.DefaultDomainRegistrarDns,
 *         DomainName = "example.com",
 *         Location = "global",
 *         Privacy = false,
 *         ResourceGroupName = "testrg123",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/domainregistration/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := domainregistration.NewDomain(ctx, "domain", &domainregistration.DomainArgs{
 * 			AuthCode:  pulumi.String("exampleAuthCode"),
 * 			AutoRenew: pulumi.Bool(true),
 * 			Consent: &domainregistration.DomainPurchaseConsentArgs{
 * 				AgreedAt: pulumi.String("2021-09-10T19:30:53Z"),
 * 				AgreedBy: pulumi.String("192.0.2.1"),
 * 				AgreementKeys: pulumi.StringArray{
 * 					pulumi.String("agreementKey1"),
 * 				},
 * 			},
 * 			ContactAdmin: &domainregistration.ContactArgs{
 * 				AddressMailing: &domainregistration.AddressArgs{
 * 					Address1:   pulumi.String("3400 State St"),
 * 					City:       pulumi.String("Chicago"),
 * 					Country:    pulumi.String("United States"),
 * 					PostalCode: pulumi.String("67098"),
 * 					State:      pulumi.String("IL"),
 * 				},
 * 				Email:        pulumi.String("admin@email.com"),
 * 				Fax:          pulumi.String("1-245-534-2242"),
 * 				JobTitle:     pulumi.String("Admin"),
 * 				NameFirst:    pulumi.String("John"),
 * 				NameLast:     pulumi.String("Doe"),
 * 				NameMiddle:   pulumi.String(""),
 * 				Organization: pulumi.String("Microsoft Inc."),
 * 				Phone:        pulumi.String("1-245-534-2242"),
 * 			},
 * 			ContactBilling: &domainregistration.ContactArgs{
 * 				AddressMailing: &domainregistration.AddressArgs{
 * 					Address1:   pulumi.String("3400 State St"),
 * 					City:       pulumi.String("Chicago"),
 * 					Country:    pulumi.String("United States"),
 * 					PostalCode: pulumi.String("67098"),
 * 					State:      pulumi.String("IL"),
 * 				},
 * 				Email:        pulumi.String("billing@email.com"),
 * 				Fax:          pulumi.String("1-245-534-2242"),
 * 				JobTitle:     pulumi.String("Billing"),
 * 				NameFirst:    pulumi.String("John"),
 * 				NameLast:     pulumi.String("Doe"),
 * 				NameMiddle:   pulumi.String(""),
 * 				Organization: pulumi.String("Microsoft Inc."),
 * 				Phone:        pulumi.String("1-245-534-2242"),
 * 			},
 * 			ContactRegistrant: &domainregistration.ContactArgs{
 * 				AddressMailing: &domainregistration.AddressArgs{
 * 					Address1:   pulumi.String("3400 State St"),
 * 					City:       pulumi.String("Chicago"),
 * 					Country:    pulumi.String("United States"),
 * 					PostalCode: pulumi.String("67098"),
 * 					State:      pulumi.String("IL"),
 * 				},
 * 				Email:        pulumi.String("registrant@email.com"),
 * 				Fax:          pulumi.String("1-245-534-2242"),
 * 				JobTitle:     pulumi.String("Registrant"),
 * 				NameFirst:    pulumi.String("John"),
 * 				NameLast:     pulumi.String("Doe"),
 * 				NameMiddle:   pulumi.String(""),
 * 				Organization: pulumi.String("Microsoft Inc."),
 * 				Phone:        pulumi.String("1-245-534-2242"),
 * 			},
 * 			ContactTech: &domainregistration.ContactArgs{
 * 				AddressMailing: &domainregistration.AddressArgs{
 * 					Address1:   pulumi.String("3400 State St"),
 * 					City:       pulumi.String("Chicago"),
 * 					Country:    pulumi.String("United States"),
 * 					PostalCode: pulumi.String("67098"),
 * 					State:      pulumi.String("IL"),
 * 				},
 * 				Email:        pulumi.String("tech@email.com"),
 * 				Fax:          pulumi.String("1-245-534-2242"),
 * 				JobTitle:     pulumi.String("Tech"),
 * 				NameFirst:    pulumi.String("John"),
 * 				NameLast:     pulumi.String("Doe"),
 * 				NameMiddle:   pulumi.String(""),
 * 				Organization: pulumi.String("Microsoft Inc."),
 * 				Phone:        pulumi.String("1-245-534-2242"),
 * 			},
 * 			DnsType:           domainregistration.DnsTypeDefaultDomainRegistrarDns,
 * 			DomainName:        pulumi.String("example.com"),
 * 			Location:          pulumi.String("global"),
 * 			Privacy:           pulumi.Bool(false),
 * 			ResourceGroupName: pulumi.String("testrg123"),
 * 			Tags:              nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.domainregistration.Domain;
 * import com.pulumi.azurenative.domainregistration.DomainArgs;
 * import com.pulumi.azurenative.domainregistration.inputs.DomainPurchaseConsentArgs;
 * import com.pulumi.azurenative.domainregistration.inputs.ContactArgs;
 * import com.pulumi.azurenative.domainregistration.inputs.AddressArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var domain = new Domain("domain", DomainArgs.builder()
 *             .authCode("exampleAuthCode")
 *             .autoRenew(true)
 *             .consent(DomainPurchaseConsentArgs.builder()
 *                 .agreedAt("2021-09-10T19:30:53Z")
 *                 .agreedBy("192.0.2.1")
 *                 .agreementKeys("agreementKey1")
 *                 .build())
 *             .contactAdmin(ContactArgs.builder()
 *                 .addressMailing(AddressArgs.builder()
 *                     .address1("3400 State St")
 *                     .city("Chicago")
 *                     .country("United States")
 *                     .postalCode("67098")
 *                     .state("IL")
 *                     .build())
 *                 .email("admin@email.com")
 *                 .fax("1-245-534-2242")
 *                 .jobTitle("Admin")
 *                 .nameFirst("John")
 *                 .nameLast("Doe")
 *                 .nameMiddle("")
 *                 .organization("Microsoft Inc.")
 *                 .phone("1-245-534-2242")
 *                 .build())
 *             .contactBilling(ContactArgs.builder()
 *                 .addressMailing(AddressArgs.builder()
 *                     .address1("3400 State St")
 *                     .city("Chicago")
 *                     .country("United States")
 *                     .postalCode("67098")
 *                     .state("IL")
 *                     .build())
 *                 .email("billing@email.com")
 *                 .fax("1-245-534-2242")
 *                 .jobTitle("Billing")
 *                 .nameFirst("John")
 *                 .nameLast("Doe")
 *                 .nameMiddle("")
 *                 .organization("Microsoft Inc.")
 *                 .phone("1-245-534-2242")
 *                 .build())
 *             .contactRegistrant(ContactArgs.builder()
 *                 .addressMailing(AddressArgs.builder()
 *                     .address1("3400 State St")
 *                     .city("Chicago")
 *                     .country("United States")
 *                     .postalCode("67098")
 *                     .state("IL")
 *                     .build())
 *                 .email("registrant@email.com")
 *                 .fax("1-245-534-2242")
 *                 .jobTitle("Registrant")
 *                 .nameFirst("John")
 *                 .nameLast("Doe")
 *                 .nameMiddle("")
 *                 .organization("Microsoft Inc.")
 *                 .phone("1-245-534-2242")
 *                 .build())
 *             .contactTech(ContactArgs.builder()
 *                 .addressMailing(AddressArgs.builder()
 *                     .address1("3400 State St")
 *                     .city("Chicago")
 *                     .country("United States")
 *                     .postalCode("67098")
 *                     .state("IL")
 *                     .build())
 *                 .email("tech@email.com")
 *                 .fax("1-245-534-2242")
 *                 .jobTitle("Tech")
 *                 .nameFirst("John")
 *                 .nameLast("Doe")
 *                 .nameMiddle("")
 *                 .organization("Microsoft Inc.")
 *                 .phone("1-245-534-2242")
 *                 .build())
 *             .dnsType("DefaultDomainRegistrarDns")
 *             .domainName("example.com")
 *             .location("global")
 *             .privacy(false)
 *             .resourceGroupName("testrg123")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:domainregistration:Domain example.com /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DomainRegistration/domains/{domainName}
 * ```
 * @property authCode
 * @property autoRenew <code>true</code> if the domain should be automatically renewed; otherwise, <code>false</code>.
 * @property consent Legal agreement consent.
 * @property contactAdmin Administrative contact.
 * @property contactBilling Billing contact.
 * @property contactRegistrant Registrant contact.
 * @property contactTech Technical contact.
 * @property dnsType Current DNS type
 * @property dnsZoneId Azure DNS Zone to use
 * @property domainName Name of the domain.
 * @property kind Kind of resource.
 * @property location Resource Location.
 * @property privacy <code>true</code> if domain privacy is enabled for this domain; otherwise, <code>false</code>.
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 * @property tags Resource tags.
 * @property targetDnsType Target DNS type (would be used for migration)
 */
public data class DomainArgs(
    public val authCode: Output<String>? = null,
    public val autoRenew: Output<Boolean>? = null,
    public val consent: Output<DomainPurchaseConsentArgs>? = null,
    public val contactAdmin: Output<ContactArgs>? = null,
    public val contactBilling: Output<ContactArgs>? = null,
    public val contactRegistrant: Output<ContactArgs>? = null,
    public val contactTech: Output<ContactArgs>? = null,
    public val dnsType: Output<DnsType>? = null,
    public val dnsZoneId: Output<String>? = null,
    public val domainName: Output<String>? = null,
    public val kind: Output<String>? = null,
    public val location: Output<String>? = null,
    public val privacy: Output<Boolean>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val targetDnsType: Output<DnsType>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.domainregistration.DomainArgs> {
    override fun toJava(): com.pulumi.azurenative.domainregistration.DomainArgs =
        com.pulumi.azurenative.domainregistration.DomainArgs.builder()
            .authCode(authCode?.applyValue({ args0 -> args0 }))
            .autoRenew(autoRenew?.applyValue({ args0 -> args0 }))
            .consent(consent?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .contactAdmin(contactAdmin?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .contactBilling(contactBilling?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .contactRegistrant(contactRegistrant?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .contactTech(contactTech?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .dnsType(dnsType?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .dnsZoneId(dnsZoneId?.applyValue({ args0 -> args0 }))
            .domainName(domainName?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .privacy(privacy?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .targetDnsType(targetDnsType?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [DomainArgs].
 */
@PulumiTagMarker
public class DomainArgsBuilder internal constructor() {
    private var authCode: Output<String>? = null

    private var autoRenew: Output<Boolean>? = null

    private var consent: Output<DomainPurchaseConsentArgs>? = null

    private var contactAdmin: Output<ContactArgs>? = null

    private var contactBilling: Output<ContactArgs>? = null

    private var contactRegistrant: Output<ContactArgs>? = null

    private var contactTech: Output<ContactArgs>? = null

    private var dnsType: Output<DnsType>? = null

    private var dnsZoneId: Output<String>? = null

    private var domainName: Output<String>? = null

    private var kind: Output<String>? = null

    private var location: Output<String>? = null

    private var privacy: Output<Boolean>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var targetDnsType: Output<DnsType>? = null

    /**
     * @param value
     */
    @JvmName("njjkkninkxxbybjr")
    public suspend fun authCode(`value`: Output<String>) {
        this.authCode = value
    }

    /**
     * @param value <code>true</code> if the domain should be automatically renewed; otherwise, <code>false</code>.
     */
    @JvmName("kjbjotwjpqrcvtyp")
    public suspend fun autoRenew(`value`: Output<Boolean>) {
        this.autoRenew = value
    }

    /**
     * @param value Legal agreement consent.
     */
    @JvmName("jurqgtvmnwammuvm")
    public suspend fun consent(`value`: Output<DomainPurchaseConsentArgs>) {
        this.consent = value
    }

    /**
     * @param value Administrative contact.
     */
    @JvmName("rlafieylghjthsqm")
    public suspend fun contactAdmin(`value`: Output<ContactArgs>) {
        this.contactAdmin = value
    }

    /**
     * @param value Billing contact.
     */
    @JvmName("xenltlwnjocpmdol")
    public suspend fun contactBilling(`value`: Output<ContactArgs>) {
        this.contactBilling = value
    }

    /**
     * @param value Registrant contact.
     */
    @JvmName("rcrycsryeinuhmum")
    public suspend fun contactRegistrant(`value`: Output<ContactArgs>) {
        this.contactRegistrant = value
    }

    /**
     * @param value Technical contact.
     */
    @JvmName("jbluaeufaxfpvyml")
    public suspend fun contactTech(`value`: Output<ContactArgs>) {
        this.contactTech = value
    }

    /**
     * @param value Current DNS type
     */
    @JvmName("kvmkbhaavnlnsgmy")
    public suspend fun dnsType(`value`: Output<DnsType>) {
        this.dnsType = value
    }

    /**
     * @param value Azure DNS Zone to use
     */
    @JvmName("ylnttbitqaedwwlr")
    public suspend fun dnsZoneId(`value`: Output<String>) {
        this.dnsZoneId = value
    }

    /**
     * @param value Name of the domain.
     */
    @JvmName("bsguteqkcgpvpexv")
    public suspend fun domainName(`value`: Output<String>) {
        this.domainName = value
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("rrcmycbktjwckeam")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Resource Location.
     */
    @JvmName("aavlwlfbivfvlhao")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value <code>true</code> if domain privacy is enabled for this domain; otherwise, <code>false</code>.
     */
    @JvmName("oeqmmsclrgurcojn")
    public suspend fun privacy(`value`: Output<Boolean>) {
        this.privacy = value
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("ffreobsusgyxbjem")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("lvhdhqjtuitvhdyf")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Target DNS type (would be used for migration)
     */
    @JvmName("muahwhuotaqvubnp")
    public suspend fun targetDnsType(`value`: Output<DnsType>) {
        this.targetDnsType = value
    }

    /**
     * @param value
     */
    @JvmName("qciaetpbgfmspuql")
    public suspend fun authCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authCode = mapped
    }

    /**
     * @param value <code>true</code> if the domain should be automatically renewed; otherwise, <code>false</code>.
     */
    @JvmName("kkqctxqvieejvoae")
    public suspend fun autoRenew(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoRenew = mapped
    }

    /**
     * @param value Legal agreement consent.
     */
    @JvmName("muetuxoiaswfmydc")
    public suspend fun consent(`value`: DomainPurchaseConsentArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.consent = mapped
    }

    /**
     * @param argument Legal agreement consent.
     */
    @JvmName("loknqavmfuqbifun")
    public suspend fun consent(argument: suspend DomainPurchaseConsentArgsBuilder.() -> Unit) {
        val toBeMapped = DomainPurchaseConsentArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.consent = mapped
    }

    /**
     * @param value Administrative contact.
     */
    @JvmName("gyycgqhmjjdwgdom")
    public suspend fun contactAdmin(`value`: ContactArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contactAdmin = mapped
    }

    /**
     * @param argument Administrative contact.
     */
    @JvmName("saghcrurvloxfvwy")
    public suspend fun contactAdmin(argument: suspend ContactArgsBuilder.() -> Unit) {
        val toBeMapped = ContactArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.contactAdmin = mapped
    }

    /**
     * @param value Billing contact.
     */
    @JvmName("ifpuqbnupjgcaaso")
    public suspend fun contactBilling(`value`: ContactArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contactBilling = mapped
    }

    /**
     * @param argument Billing contact.
     */
    @JvmName("xghauvtexvtordys")
    public suspend fun contactBilling(argument: suspend ContactArgsBuilder.() -> Unit) {
        val toBeMapped = ContactArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.contactBilling = mapped
    }

    /**
     * @param value Registrant contact.
     */
    @JvmName("rlkocblbsonbkdlc")
    public suspend fun contactRegistrant(`value`: ContactArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contactRegistrant = mapped
    }

    /**
     * @param argument Registrant contact.
     */
    @JvmName("pqydbbgusrkoxmdu")
    public suspend fun contactRegistrant(argument: suspend ContactArgsBuilder.() -> Unit) {
        val toBeMapped = ContactArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.contactRegistrant = mapped
    }

    /**
     * @param value Technical contact.
     */
    @JvmName("xpsewxyfppquvscj")
    public suspend fun contactTech(`value`: ContactArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contactTech = mapped
    }

    /**
     * @param argument Technical contact.
     */
    @JvmName("lwoevtylktgjbumo")
    public suspend fun contactTech(argument: suspend ContactArgsBuilder.() -> Unit) {
        val toBeMapped = ContactArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.contactTech = mapped
    }

    /**
     * @param value Current DNS type
     */
    @JvmName("pfiatsbogpkqibcs")
    public suspend fun dnsType(`value`: DnsType?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsType = mapped
    }

    /**
     * @param value Azure DNS Zone to use
     */
    @JvmName("wqsrgmdxftnjfsyy")
    public suspend fun dnsZoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsZoneId = mapped
    }

    /**
     * @param value Name of the domain.
     */
    @JvmName("cpmbuywxqrssiubt")
    public suspend fun domainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainName = mapped
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("jgvbxpuwywvcayfa")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Resource Location.
     */
    @JvmName("nypxdcmrriliaypo")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value <code>true</code> if domain privacy is enabled for this domain; otherwise, <code>false</code>.
     */
    @JvmName("edyxjlpwlopawgtn")
    public suspend fun privacy(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privacy = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("owdfqgbwfmnjdark")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("opwqtcyljbugyvne")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("lyfgnyrjhslncejt")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Target DNS type (would be used for migration)
     */
    @JvmName("ijvdncvnlwmheaiq")
    public suspend fun targetDnsType(`value`: DnsType?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetDnsType = mapped
    }

    internal fun build(): DomainArgs = DomainArgs(
        authCode = authCode,
        autoRenew = autoRenew,
        consent = consent,
        contactAdmin = contactAdmin,
        contactBilling = contactBilling,
        contactRegistrant = contactRegistrant,
        contactTech = contactTech,
        dnsType = dnsType,
        dnsZoneId = dnsZoneId,
        domainName = domainName,
        kind = kind,
        location = location,
        privacy = privacy,
        resourceGroupName = resourceGroupName,
        tags = tags,
        targetDnsType = targetDnsType,
    )
}
