@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.domainregistration.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [DomainOwnershipIdentifier].
 */
@PulumiTagMarker
public class DomainOwnershipIdentifierResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DomainOwnershipIdentifierArgs = DomainOwnershipIdentifierArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DomainOwnershipIdentifierArgsBuilder.() -> Unit) {
        val builder = DomainOwnershipIdentifierArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DomainOwnershipIdentifier {
        val builtJavaResource =
            com.pulumi.azurenative.domainregistration.DomainOwnershipIdentifier(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return DomainOwnershipIdentifier(builtJavaResource)
    }
}

/**
 * Domain ownership Identifier.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2020-10-01.
 * Other available API versions: 2020-10-01, 2023-01-01.
 * ## Example Usage
 * ### Create App Service Domain OwnershipIdentifier
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var domainOwnershipIdentifier = new AzureNative.DomainRegistration.DomainOwnershipIdentifier("domainOwnershipIdentifier", new()
 *     {
 *         DomainName = "example.com",
 *         Name = "SampleOwnershipId",
 *         OwnershipId = "SampleOwnershipId",
 *         ResourceGroupName = "testrg123",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/domainregistration/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := domainregistration.NewDomainOwnershipIdentifier(ctx, "domainOwnershipIdentifier", &domainregistration.DomainOwnershipIdentifierArgs{
 * 			DomainName:        pulumi.String("example.com"),
 * 			Name:              pulumi.String("SampleOwnershipId"),
 * 			OwnershipId:       pulumi.String("SampleOwnershipId"),
 * 			ResourceGroupName: pulumi.String("testrg123"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.domainregistration.DomainOwnershipIdentifier;
 * import com.pulumi.azurenative.domainregistration.DomainOwnershipIdentifierArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var domainOwnershipIdentifier = new DomainOwnershipIdentifier("domainOwnershipIdentifier", DomainOwnershipIdentifierArgs.builder()
 *             .domainName("example.com")
 *             .name("SampleOwnershipId")
 *             .ownershipId("SampleOwnershipId")
 *             .resourceGroupName("testrg123")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:domainregistration:DomainOwnershipIdentifier SampleOwnershipId /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DomainRegistration/domains/{domainName}/domainOwnershipIdentifiers/{name}
 * ```
 */
public class DomainOwnershipIdentifier internal constructor(
    override val javaResource: com.pulumi.azurenative.domainregistration.DomainOwnershipIdentifier,
) : KotlinCustomResource(javaResource, DomainOwnershipIdentifierMapper) {
    /**
     * Kind of resource.
     */
    public val kind: Output<String>?
        get() = javaResource.kind().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource Name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Ownership Id.
     */
    public val ownershipId: Output<String>?
        get() = javaResource.ownershipId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object DomainOwnershipIdentifierMapper : ResourceMapper<DomainOwnershipIdentifier> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.domainregistration.DomainOwnershipIdentifier::class == javaResource::class

    override fun map(javaResource: Resource): DomainOwnershipIdentifier =
        DomainOwnershipIdentifier(
            javaResource as
                com.pulumi.azurenative.domainregistration.DomainOwnershipIdentifier,
        )
}

/**
 * @see [DomainOwnershipIdentifier].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DomainOwnershipIdentifier].
 */
public suspend fun domainOwnershipIdentifier(
    name: String,
    block: suspend DomainOwnershipIdentifierResourceBuilder.() -> Unit,
): DomainOwnershipIdentifier {
    val builder = DomainOwnershipIdentifierResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DomainOwnershipIdentifier].
 * @param name The _unique_ name of the resulting resource.
 */
public fun domainOwnershipIdentifier(name: String): DomainOwnershipIdentifier {
    val builder = DomainOwnershipIdentifierResourceBuilder()
    builder.name(name)
    return builder.build()
}
