@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.domainregistration.kotlin

import com.pulumi.azurenative.domainregistration.DomainOwnershipIdentifierArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Domain ownership Identifier.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2020-10-01.
 * Other available API versions: 2020-10-01, 2023-01-01.
 * ## Example Usage
 * ### Create App Service Domain OwnershipIdentifier
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var domainOwnershipIdentifier = new AzureNative.DomainRegistration.DomainOwnershipIdentifier("domainOwnershipIdentifier", new()
 *     {
 *         DomainName = "example.com",
 *         Name = "SampleOwnershipId",
 *         OwnershipId = "SampleOwnershipId",
 *         ResourceGroupName = "testrg123",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/domainregistration/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := domainregistration.NewDomainOwnershipIdentifier(ctx, "domainOwnershipIdentifier", &domainregistration.DomainOwnershipIdentifierArgs{
 * 			DomainName:        pulumi.String("example.com"),
 * 			Name:              pulumi.String("SampleOwnershipId"),
 * 			OwnershipId:       pulumi.String("SampleOwnershipId"),
 * 			ResourceGroupName: pulumi.String("testrg123"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.domainregistration.DomainOwnershipIdentifier;
 * import com.pulumi.azurenative.domainregistration.DomainOwnershipIdentifierArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var domainOwnershipIdentifier = new DomainOwnershipIdentifier("domainOwnershipIdentifier", DomainOwnershipIdentifierArgs.builder()
 *             .domainName("example.com")
 *             .name("SampleOwnershipId")
 *             .ownershipId("SampleOwnershipId")
 *             .resourceGroupName("testrg123")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:domainregistration:DomainOwnershipIdentifier SampleOwnershipId /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DomainRegistration/domains/{domainName}/domainOwnershipIdentifiers/{name}
 * ```
 * @property domainName Name of domain.
 * @property kind Kind of resource.
 * @property name Name of identifier.
 * @property ownershipId Ownership Id.
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 */
public data class DomainOwnershipIdentifierArgs(
    public val domainName: Output<String>? = null,
    public val kind: Output<String>? = null,
    public val name: Output<String>? = null,
    public val ownershipId: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.domainregistration.DomainOwnershipIdentifierArgs> {
    override fun toJava(): com.pulumi.azurenative.domainregistration.DomainOwnershipIdentifierArgs =
        com.pulumi.azurenative.domainregistration.DomainOwnershipIdentifierArgs.builder()
            .domainName(domainName?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .ownershipId(ownershipId?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainOwnershipIdentifierArgs].
 */
@PulumiTagMarker
public class DomainOwnershipIdentifierArgsBuilder internal constructor() {
    private var domainName: Output<String>? = null

    private var kind: Output<String>? = null

    private var name: Output<String>? = null

    private var ownershipId: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value Name of domain.
     */
    @JvmName("hwswuyuphjjpmxla")
    public suspend fun domainName(`value`: Output<String>) {
        this.domainName = value
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("iiouvuhvnubsswlq")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Name of identifier.
     */
    @JvmName("vemomrlfmyuqcfll")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Ownership Id.
     */
    @JvmName("adrrxjwyqtcyfvte")
    public suspend fun ownershipId(`value`: Output<String>) {
        this.ownershipId = value
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("vxqogjqgokigfnab")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Name of domain.
     */
    @JvmName("hqjxyrmukuokceqe")
    public suspend fun domainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainName = mapped
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("wdbpngdmxgnosdyu")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Name of identifier.
     */
    @JvmName("vddkaclstyenfwgi")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Ownership Id.
     */
    @JvmName("jtkmhddarvvyfbop")
    public suspend fun ownershipId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ownershipId = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("awbiwpeblvoswalr")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): DomainOwnershipIdentifierArgs = DomainOwnershipIdentifierArgs(
        domainName = domainName,
        kind = kind,
        name = name,
        ownershipId = ownershipId,
        resourceGroupName = resourceGroupName,
    )
}
