@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.domainregistration.kotlin

import com.pulumi.azurenative.domainregistration.DomainregistrationFunctions.getDomainOwnershipIdentifierPlain
import com.pulumi.azurenative.domainregistration.DomainregistrationFunctions.getDomainPlain
import com.pulumi.azurenative.domainregistration.DomainregistrationFunctions.listDomainRecommendationsPlain
import com.pulumi.azurenative.domainregistration.DomainregistrationFunctions.listTopLevelDomainAgreementsPlain
import com.pulumi.azurenative.domainregistration.kotlin.inputs.GetDomainOwnershipIdentifierPlainArgs
import com.pulumi.azurenative.domainregistration.kotlin.inputs.GetDomainOwnershipIdentifierPlainArgsBuilder
import com.pulumi.azurenative.domainregistration.kotlin.inputs.GetDomainPlainArgs
import com.pulumi.azurenative.domainregistration.kotlin.inputs.GetDomainPlainArgsBuilder
import com.pulumi.azurenative.domainregistration.kotlin.inputs.ListDomainRecommendationsPlainArgs
import com.pulumi.azurenative.domainregistration.kotlin.inputs.ListDomainRecommendationsPlainArgsBuilder
import com.pulumi.azurenative.domainregistration.kotlin.inputs.ListTopLevelDomainAgreementsPlainArgs
import com.pulumi.azurenative.domainregistration.kotlin.inputs.ListTopLevelDomainAgreementsPlainArgsBuilder
import com.pulumi.azurenative.domainregistration.kotlin.outputs.GetDomainOwnershipIdentifierResult
import com.pulumi.azurenative.domainregistration.kotlin.outputs.GetDomainResult
import com.pulumi.azurenative.domainregistration.kotlin.outputs.ListDomainRecommendationsResult
import com.pulumi.azurenative.domainregistration.kotlin.outputs.ListTopLevelDomainAgreementsResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.domainregistration.kotlin.outputs.GetDomainOwnershipIdentifierResult.Companion.toKotlin as getDomainOwnershipIdentifierResultToKotlin
import com.pulumi.azurenative.domainregistration.kotlin.outputs.GetDomainResult.Companion.toKotlin as getDomainResultToKotlin
import com.pulumi.azurenative.domainregistration.kotlin.outputs.ListDomainRecommendationsResult.Companion.toKotlin as listDomainRecommendationsResultToKotlin
import com.pulumi.azurenative.domainregistration.kotlin.outputs.ListTopLevelDomainAgreementsResult.Companion.toKotlin as listTopLevelDomainAgreementsResultToKotlin

public object DomainregistrationFunctions {
    /**
     * Description for Get a domain.
     * Azure REST API version: 2022-09-01.
     * Other available API versions: 2020-10-01, 2023-01-01.
     * @param argument null
     * @return Information about a domain.
     */
    public suspend fun getDomain(argument: GetDomainPlainArgs): GetDomainResult =
        getDomainResultToKotlin(getDomainPlain(argument.toJava()).await())

    /**
     * @see [getDomain].
     * @param domainName Name of the domain.
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @return Information about a domain.
     */
    public suspend fun getDomain(domainName: String, resourceGroupName: String): GetDomainResult {
        val argument = GetDomainPlainArgs(
            domainName = domainName,
            resourceGroupName = resourceGroupName,
        )
        return getDomainResultToKotlin(getDomainPlain(argument.toJava()).await())
    }

    /**
     * @see [getDomain].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;domainregistration&#46;kotlin&#46;inputs&#46;GetDomainPlainArgs].
     * @return Information about a domain.
     */
    public suspend fun getDomain(argument: suspend GetDomainPlainArgsBuilder.() -> Unit):
        GetDomainResult {
        val builder = GetDomainPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDomainResultToKotlin(getDomainPlain(builtArgument.toJava()).await())
    }

    /**
     * Description for Get ownership identifier for domain
     * Azure REST API version: 2022-09-01.
     * Other available API versions: 2020-10-01, 2023-01-01.
     * @param argument null
     * @return Domain ownership Identifier.
     */
    public suspend fun getDomainOwnershipIdentifier(argument: GetDomainOwnershipIdentifierPlainArgs):
        GetDomainOwnershipIdentifierResult =
        getDomainOwnershipIdentifierResultToKotlin(getDomainOwnershipIdentifierPlain(argument.toJava()).await())

    /**
     * @see [getDomainOwnershipIdentifier].
     * @param domainName Name of domain.
     * @param name Name of identifier.
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @return Domain ownership Identifier.
     */
    public suspend fun getDomainOwnershipIdentifier(
        domainName: String,
        name: String,
        resourceGroupName: String,
    ): GetDomainOwnershipIdentifierResult {
        val argument = GetDomainOwnershipIdentifierPlainArgs(
            domainName = domainName,
            name = name,
            resourceGroupName = resourceGroupName,
        )
        return getDomainOwnershipIdentifierResultToKotlin(getDomainOwnershipIdentifierPlain(argument.toJava()).await())
    }

    /**
     * @see [getDomainOwnershipIdentifier].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;domainregistration&#46;kotlin&#46;inputs&#46;GetDomainOwnershipIdentifierPlainArgs].
     * @return Domain ownership Identifier.
     */
    public suspend
    fun getDomainOwnershipIdentifier(argument: suspend GetDomainOwnershipIdentifierPlainArgsBuilder.() -> Unit):
        GetDomainOwnershipIdentifierResult {
        val builder = GetDomainOwnershipIdentifierPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDomainOwnershipIdentifierResultToKotlin(getDomainOwnershipIdentifierPlain(builtArgument.toJava()).await())
    }

    /**
     * Description for Get domain name recommendations based on keywords.
     * Azure REST API version: 2022-09-01.
     * Other available API versions: 2015-04-01, 2018-02-01, 2019-08-01, 2020-06-01, 2020-09-01, 2020-10-01, 2020-12-01, 2021-01-01, 2021-01-15, 2021-02-01, 2021-03-01, 2022-03-01, 2023-01-01.
     * @param argument null
     * @return Collection of domain name identifiers.
     */
    public suspend fun listDomainRecommendations(argument: ListDomainRecommendationsPlainArgs):
        ListDomainRecommendationsResult =
        listDomainRecommendationsResultToKotlin(listDomainRecommendationsPlain(argument.toJava()).await())

    /**
     * @see [listDomainRecommendations].
     * @param keywords Keywords to be used for generating domain recommendations.
     * @param maxDomainRecommendations Maximum number of recommendations.
     * @return Collection of domain name identifiers.
     */
    public suspend fun listDomainRecommendations(
        keywords: String? = null,
        maxDomainRecommendations: Int? = null,
    ): ListDomainRecommendationsResult {
        val argument = ListDomainRecommendationsPlainArgs(
            keywords = keywords,
            maxDomainRecommendations = maxDomainRecommendations,
        )
        return listDomainRecommendationsResultToKotlin(listDomainRecommendationsPlain(argument.toJava()).await())
    }

    /**
     * @see [listDomainRecommendations].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;domainregistration&#46;kotlin&#46;inputs&#46;ListDomainRecommendationsPlainArgs].
     * @return Collection of domain name identifiers.
     */
    public suspend
    fun listDomainRecommendations(argument: suspend ListDomainRecommendationsPlainArgsBuilder.() -> Unit):
        ListDomainRecommendationsResult {
        val builder = ListDomainRecommendationsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listDomainRecommendationsResultToKotlin(listDomainRecommendationsPlain(builtArgument.toJava()).await())
    }

    /**
     * Description for Gets all legal agreements that user needs to accept before purchasing a domain.
     * Azure REST API version: 2022-09-01.
     * Other available API versions: 2015-04-01, 2018-02-01, 2019-08-01, 2020-06-01, 2020-09-01, 2020-10-01, 2020-12-01, 2021-01-01, 2021-01-15, 2021-02-01, 2021-03-01, 2022-03-01, 2023-01-01.
     * @param argument null
     * @return Collection of top-level domain legal agreements.
     */
    public suspend fun listTopLevelDomainAgreements(argument: ListTopLevelDomainAgreementsPlainArgs):
        ListTopLevelDomainAgreementsResult =
        listTopLevelDomainAgreementsResultToKotlin(listTopLevelDomainAgreementsPlain(argument.toJava()).await())

    /**
     * @see [listTopLevelDomainAgreements].
     * @param forTransfer If <code>true</code>, then the list of agreements will include agreements for domain transfer as well; otherwise, <code>false</code>.
     * @param includePrivacy If <code>true</code>, then the list of agreements will include agreements for domain privacy as well; otherwise, <code>false</code>.
     * @param name Name of the top-level domain.
     * @return Collection of top-level domain legal agreements.
     */
    public suspend fun listTopLevelDomainAgreements(
        forTransfer: Boolean? = null,
        includePrivacy: Boolean? = null,
        name: String,
    ): ListTopLevelDomainAgreementsResult {
        val argument = ListTopLevelDomainAgreementsPlainArgs(
            forTransfer = forTransfer,
            includePrivacy = includePrivacy,
            name = name,
        )
        return listTopLevelDomainAgreementsResultToKotlin(listTopLevelDomainAgreementsPlain(argument.toJava()).await())
    }

    /**
     * @see [listTopLevelDomainAgreements].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;domainregistration&#46;kotlin&#46;inputs&#46;ListTopLevelDomainAgreementsPlainArgs].
     * @return Collection of top-level domain legal agreements.
     */
    public suspend
    fun listTopLevelDomainAgreements(argument: suspend ListTopLevelDomainAgreementsPlainArgsBuilder.() -> Unit):
        ListTopLevelDomainAgreementsResult {
        val builder = ListTopLevelDomainAgreementsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listTopLevelDomainAgreementsResultToKotlin(listTopLevelDomainAgreementsPlain(builtArgument.toJava()).await())
    }
}
