@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dynamics365fraudprotection.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Represents an instance of a DFP instance resource.
 * @property administration A collection of DFP instance administrators
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property location Location of the DFP resource.
 * @property name The name of the resource
 * @property provisioningState The current deployment state of DFP resource. The provisioningState is to indicate states for resource provisioning.
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property tags Key-value pairs of additional resource provisioning properties.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetInstanceDetailsResult(
    public val administration: DFPInstanceAdministratorsResponse? = null,
    public val id: String,
    public val location: String,
    public val name: String,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.dynamics365fraudprotection.outputs.GetInstanceDetailsResult):
            GetInstanceDetailsResult = GetInstanceDetailsResult(
            administration = javaType.administration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.dynamics365fraudprotection.kotlin.outputs.DFPInstanceAdministratorsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.dynamics365fraudprotection.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
