@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.edgeorder.kotlin

import com.pulumi.azurenative.edgeorder.AddressArgs.builder
import com.pulumi.azurenative.edgeorder.kotlin.inputs.ContactDetailsArgs
import com.pulumi.azurenative.edgeorder.kotlin.inputs.ContactDetailsArgsBuilder
import com.pulumi.azurenative.edgeorder.kotlin.inputs.ShippingAddressArgs
import com.pulumi.azurenative.edgeorder.kotlin.inputs.ShippingAddressArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Address Resource.
 * Azure REST API version: 2022-05-01-preview.
 * Other available API versions: 2024-02-01.
 * ## Example Usage
 * ### CreateAddress
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var address = new AzureNative.EdgeOrder.Address("address", new()
 *     {
 *         AddressName = "TestAddressName2",
 *         ContactDetails = new AzureNative.EdgeOrder.Inputs.ContactDetailsArgs
 *         {
 *             ContactName = "XXXX XXXX",
 *             EmailList = new[]
 *             {
 *                 "xxxx@xxxx.xxx",
 *             },
 *             Phone = "0000000000",
 *             PhoneExtension = "",
 *         },
 *         Location = "eastus",
 *         ResourceGroupName = "YourResourceGroupName",
 *         ShippingAddress = new AzureNative.EdgeOrder.Inputs.ShippingAddressArgs
 *         {
 *             AddressType = AzureNative.EdgeOrder.AddressType.None,
 *             City = "San Francisco",
 *             CompanyName = "Microsoft",
 *             Country = "US",
 *             PostalCode = "94107",
 *             StateOrProvince = "CA",
 *             StreetAddress1 = "16 TOWNSEND ST",
 *             StreetAddress2 = "UNIT 1",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/edgeorder/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := edgeorder.NewAddress(ctx, "address", &edgeorder.AddressArgs{
 * 			AddressName: pulumi.String("TestAddressName2"),
 * 			ContactDetails: &edgeorder.ContactDetailsArgs{
 * 				ContactName: pulumi.String("XXXX XXXX"),
 * 				EmailList: pulumi.StringArray{
 * 					pulumi.String("xxxx@xxxx.xxx"),
 * 				},
 * 				Phone:          pulumi.String("0000000000"),
 * 				PhoneExtension: pulumi.String(""),
 * 			},
 * 			Location:          pulumi.String("eastus"),
 * 			ResourceGroupName: pulumi.String("YourResourceGroupName"),
 * 			ShippingAddress: &edgeorder.ShippingAddressArgs{
 * 				AddressType:     pulumi.String(edgeorder.AddressTypeNone),
 * 				City:            pulumi.String("San Francisco"),
 * 				CompanyName:     pulumi.String("Microsoft"),
 * 				Country:         pulumi.String("US"),
 * 				PostalCode:      pulumi.String("94107"),
 * 				StateOrProvince: pulumi.String("CA"),
 * 				StreetAddress1:  pulumi.String("16 TOWNSEND ST"),
 * 				StreetAddress2:  pulumi.String("UNIT 1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.edgeorder.Address;
 * import com.pulumi.azurenative.edgeorder.AddressArgs;
 * import com.pulumi.azurenative.edgeorder.inputs.ContactDetailsArgs;
 * import com.pulumi.azurenative.edgeorder.inputs.ShippingAddressArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var address = new Address("address", AddressArgs.builder()
 *             .addressName("TestAddressName2")
 *             .contactDetails(ContactDetailsArgs.builder()
 *                 .contactName("XXXX XXXX")
 *                 .emailList("xxxx@xxxx.xxx")
 *                 .phone("0000000000")
 *                 .phoneExtension("")
 *                 .build())
 *             .location("eastus")
 *             .resourceGroupName("YourResourceGroupName")
 *             .shippingAddress(ShippingAddressArgs.builder()
 *                 .addressType("None")
 *                 .city("San Francisco")
 *                 .companyName("Microsoft")
 *                 .country("US")
 *                 .postalCode("94107")
 *                 .stateOrProvince("CA")
 *                 .streetAddress1("16 TOWNSEND ST")
 *                 .streetAddress2("UNIT 1")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:edgeorder:Address TestAddressName2 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EdgeOrder/addresses/{addressName}
 * ```
 * @property addressName The name of the address Resource within the specified resource group. address names must be between 3 and 24 characters in length and use any alphanumeric and underscore only.
 * @property contactDetails Contact details for the address.
 * @property location The geo-location where the resource lives
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property shippingAddress Shipping details for the address.
 * @property tags Resource tags.
 */
public data class AddressArgs(
    public val addressName: Output<String>? = null,
    public val contactDetails: Output<ContactDetailsArgs>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val shippingAddress: Output<ShippingAddressArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.edgeorder.AddressArgs> {
    override fun toJava(): com.pulumi.azurenative.edgeorder.AddressArgs =
        com.pulumi.azurenative.edgeorder.AddressArgs.builder()
            .addressName(addressName?.applyValue({ args0 -> args0 }))
            .contactDetails(contactDetails?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .shippingAddress(shippingAddress?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [AddressArgs].
 */
@PulumiTagMarker
public class AddressArgsBuilder internal constructor() {
    private var addressName: Output<String>? = null

    private var contactDetails: Output<ContactDetailsArgs>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var shippingAddress: Output<ShippingAddressArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the address Resource within the specified resource group. address names must be between 3 and 24 characters in length and use any alphanumeric and underscore only.
     */
    @JvmName("uxdymfujnoflatjg")
    public suspend fun addressName(`value`: Output<String>) {
        this.addressName = value
    }

    /**
     * @param value Contact details for the address.
     */
    @JvmName("fjofavekmsxpmabt")
    public suspend fun contactDetails(`value`: Output<ContactDetailsArgs>) {
        this.contactDetails = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("rryyegewfacjejnf")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("qobjmcduuxgotqut")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Shipping details for the address.
     */
    @JvmName("cutftcsucigdkkuk")
    public suspend fun shippingAddress(`value`: Output<ShippingAddressArgs>) {
        this.shippingAddress = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("obhahufioqdonbnc")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the address Resource within the specified resource group. address names must be between 3 and 24 characters in length and use any alphanumeric and underscore only.
     */
    @JvmName("mvvumwevsoaehwdw")
    public suspend fun addressName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addressName = mapped
    }

    /**
     * @param value Contact details for the address.
     */
    @JvmName("xhlwhokcceqwserg")
    public suspend fun contactDetails(`value`: ContactDetailsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contactDetails = mapped
    }

    /**
     * @param argument Contact details for the address.
     */
    @JvmName("moqdssquhmaeyqwa")
    public suspend fun contactDetails(argument: suspend ContactDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = ContactDetailsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.contactDetails = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("kkvvacdxlwkrnqxi")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("tciqrualuyckomlv")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Shipping details for the address.
     */
    @JvmName("qmkdwcmklulwjcva")
    public suspend fun shippingAddress(`value`: ShippingAddressArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.shippingAddress = mapped
    }

    /**
     * @param argument Shipping details for the address.
     */
    @JvmName("igsnsabrgtkmhurb")
    public suspend fun shippingAddress(argument: suspend ShippingAddressArgsBuilder.() -> Unit) {
        val toBeMapped = ShippingAddressArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.shippingAddress = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("qrlrsopsstterawt")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("nlulhfawtvmgniox")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): AddressArgs = AddressArgs(
        addressName = addressName,
        contactDetails = contactDetails,
        location = location,
        resourceGroupName = resourceGroupName,
        shippingAddress = shippingAddress,
        tags = tags,
    )
}
