@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.edgeorder.kotlin

import com.pulumi.azurenative.edgeorder.kotlin.outputs.ContactDetailsResponse
import com.pulumi.azurenative.edgeorder.kotlin.outputs.ShippingAddressResponse
import com.pulumi.azurenative.edgeorder.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.edgeorder.kotlin.outputs.ContactDetailsResponse.Companion.toKotlin as contactDetailsResponseToKotlin
import com.pulumi.azurenative.edgeorder.kotlin.outputs.ShippingAddressResponse.Companion.toKotlin as shippingAddressResponseToKotlin
import com.pulumi.azurenative.edgeorder.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [AddressByName].
 */
@PulumiTagMarker
public class AddressByNameResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AddressByNameArgs = AddressByNameArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AddressByNameArgsBuilder.() -> Unit) {
        val builder = AddressByNameArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AddressByName {
        val builtJavaResource = com.pulumi.azurenative.edgeorder.AddressByName(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AddressByName(builtJavaResource)
    }
}

/**
 * Address Resource.
 * Azure REST API version: 2021-12-01. Prior API version in Azure Native 1.x: 2021-12-01.
 * ## Example Usage
 * ### CreateAddress
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var addressByName = new AzureNative.EdgeOrder.AddressByName("addressByName", new()
 *     {
 *         AddressName = "TestAddressName2",
 *         ContactDetails = new AzureNative.EdgeOrder.Inputs.ContactDetailsArgs
 *         {
 *             ContactName = "XXXX XXXX",
 *             EmailList = new[]
 *             {
 *                 "xxxx@xxxx.xxx",
 *             },
 *             Phone = "0000000000",
 *             PhoneExtension = "",
 *         },
 *         Location = "eastus",
 *         ResourceGroupName = "YourResourceGroupName",
 *         ShippingAddress = new AzureNative.EdgeOrder.Inputs.ShippingAddressArgs
 *         {
 *             AddressType = AzureNative.EdgeOrder.AddressType.None,
 *             City = "San Francisco",
 *             CompanyName = "Microsoft",
 *             Country = "US",
 *             PostalCode = "94107",
 *             StateOrProvince = "CA",
 *             StreetAddress1 = "16 TOWNSEND ST",
 *             StreetAddress2 = "UNIT 1",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/edgeorder/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := edgeorder.NewAddressByName(ctx, "addressByName", &edgeorder.AddressByNameArgs{
 * 			AddressName: pulumi.String("TestAddressName2"),
 * 			ContactDetails: &edgeorder.ContactDetailsArgs{
 * 				ContactName: pulumi.String("XXXX XXXX"),
 * 				EmailList: pulumi.StringArray{
 * 					pulumi.String("xxxx@xxxx.xxx"),
 * 				},
 * 				Phone:          pulumi.String("0000000000"),
 * 				PhoneExtension: pulumi.String(""),
 * 			},
 * 			Location:          pulumi.String("eastus"),
 * 			ResourceGroupName: pulumi.String("YourResourceGroupName"),
 * 			ShippingAddress: &edgeorder.ShippingAddressArgs{
 * 				AddressType:     pulumi.String(edgeorder.AddressTypeNone),
 * 				City:            pulumi.String("San Francisco"),
 * 				CompanyName:     pulumi.String("Microsoft"),
 * 				Country:         pulumi.String("US"),
 * 				PostalCode:      pulumi.String("94107"),
 * 				StateOrProvince: pulumi.String("CA"),
 * 				StreetAddress1:  pulumi.String("16 TOWNSEND ST"),
 * 				StreetAddress2:  pulumi.String("UNIT 1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.edgeorder.AddressByName;
 * import com.pulumi.azurenative.edgeorder.AddressByNameArgs;
 * import com.pulumi.azurenative.edgeorder.inputs.ContactDetailsArgs;
 * import com.pulumi.azurenative.edgeorder.inputs.ShippingAddressArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var addressByName = new AddressByName("addressByName", AddressByNameArgs.builder()
 *             .addressName("TestAddressName2")
 *             .contactDetails(ContactDetailsArgs.builder()
 *                 .contactName("XXXX XXXX")
 *                 .emailList("xxxx@xxxx.xxx")
 *                 .phone("0000000000")
 *                 .phoneExtension("")
 *                 .build())
 *             .location("eastus")
 *             .resourceGroupName("YourResourceGroupName")
 *             .shippingAddress(ShippingAddressArgs.builder()
 *                 .addressType("None")
 *                 .city("San Francisco")
 *                 .companyName("Microsoft")
 *                 .country("US")
 *                 .postalCode("94107")
 *                 .stateOrProvince("CA")
 *                 .streetAddress1("16 TOWNSEND ST")
 *                 .streetAddress2("UNIT 1")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:edgeorder:AddressByName TestAddressName2 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EdgeOrder/addresses/{addressName}
 * ```
 */
public class AddressByName internal constructor(
    override val javaResource: com.pulumi.azurenative.edgeorder.AddressByName,
) : KotlinCustomResource(javaResource, AddressByNameMapper) {
    /**
     * Status of address validation
     */
    public val addressValidationStatus: Output<String>
        get() = javaResource.addressValidationStatus().applyValue({ args0 -> args0 })

    /**
     * Contact details for the address
     */
    public val contactDetails: Output<ContactDetailsResponse>
        get() = javaResource.contactDetails().applyValue({ args0 ->
            args0.let({ args0 ->
                contactDetailsResponseToKotlin(args0)
            })
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Shipping details for the address
     */
    public val shippingAddress: Output<ShippingAddressResponse>?
        get() = javaResource.shippingAddress().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> shippingAddressResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Represents resource creation and update time
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object AddressByNameMapper : ResourceMapper<AddressByName> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.edgeorder.AddressByName::class == javaResource::class

    override fun map(javaResource: Resource): AddressByName = AddressByName(
        javaResource as
            com.pulumi.azurenative.edgeorder.AddressByName,
    )
}

/**
 * @see [AddressByName].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AddressByName].
 */
public suspend fun addressByName(
    name: String,
    block: suspend AddressByNameResourceBuilder.() -> Unit,
): AddressByName {
    val builder = AddressByNameResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AddressByName].
 * @param name The _unique_ name of the resulting resource.
 */
public fun addressByName(name: String): AddressByName {
    val builder = AddressByNameResourceBuilder()
    builder.name(name)
    return builder.build()
}
