@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.edgeorder.kotlin

import com.pulumi.azurenative.edgeorder.OrderItemByNameArgs.builder
import com.pulumi.azurenative.edgeorder.kotlin.inputs.AddressDetailsArgs
import com.pulumi.azurenative.edgeorder.kotlin.inputs.AddressDetailsArgsBuilder
import com.pulumi.azurenative.edgeorder.kotlin.inputs.OrderItemDetailsArgs
import com.pulumi.azurenative.edgeorder.kotlin.inputs.OrderItemDetailsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Represents order item contract
 * Azure REST API version: 2021-12-01. Prior API version in Azure Native 1.x: 2021-12-01.
 * ## Example Usage
 * ### CreateOrderItem
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var orderItemByName = new AzureNative.EdgeOrder.OrderItemByName("orderItemByName", new()
 *     {
 *         AddressDetails = new AzureNative.EdgeOrder.Inputs.AddressDetailsArgs
 *         {
 *             ForwardAddress = new AzureNative.EdgeOrder.Inputs.AddressPropertiesArgs
 *             {
 *                 ContactDetails = new AzureNative.EdgeOrder.Inputs.ContactDetailsArgs
 *                 {
 *                     ContactName = "XXXX XXXX",
 *                     EmailList = new[]
 *                     {
 *                         "xxxx@xxxx.xxx",
 *                     },
 *                     Phone = "0000000000",
 *                     PhoneExtension = "",
 *                 },
 *                 ShippingAddress = new AzureNative.EdgeOrder.Inputs.ShippingAddressArgs
 *                 {
 *                     AddressType = AzureNative.EdgeOrder.AddressType.None,
 *                     City = "San Francisco",
 *                     CompanyName = "Microsoft",
 *                     Country = "US",
 *                     PostalCode = "94107",
 *                     StateOrProvince = "CA",
 *                     StreetAddress1 = "16 TOWNSEND ST",
 *                     StreetAddress2 = "UNIT 1",
 *                 },
 *             },
 *         },
 *         Location = "eastus",
 *         OrderId = "/subscriptions/YourSubscriptionId/resourceGroups/YourResourceGroupName/providers/Microsoft.EdgeOrder/locations/eastus/orders/TestOrderName2",
 *         OrderItemDetails = new AzureNative.EdgeOrder.Inputs.OrderItemDetailsArgs
 *         {
 *             OrderItemType = AzureNative.EdgeOrder.OrderItemType.Purchase,
 *             Preferences = new AzureNative.EdgeOrder.Inputs.PreferencesArgs
 *             {
 *                 TransportPreferences = new AzureNative.EdgeOrder.Inputs.TransportPreferencesArgs
 *                 {
 *                     PreferredShipmentType = AzureNative.EdgeOrder.TransportShipmentTypes.MicrosoftManaged,
 *                 },
 *             },
 *             ProductDetails = new AzureNative.EdgeOrder.Inputs.ProductDetailsArgs
 *             {
 *                 HierarchyInformation = new AzureNative.EdgeOrder.Inputs.HierarchyInformationArgs
 *                 {
 *                     ConfigurationName = "edgep_base",
 *                     ProductFamilyName = "azurestackedge",
 *                     ProductLineName = "azurestackedge",
 *                     ProductName = "azurestackedgegpu",
 *                 },
 *             },
 *         },
 *         OrderItemName = "TestOrderItemName2",
 *         ResourceGroupName = "YourResourceGroupName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/edgeorder/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := edgeorder.NewOrderItemByName(ctx, "orderItemByName", &edgeorder.OrderItemByNameArgs{
 * 			AddressDetails: &edgeorder.AddressDetailsArgs{
 * 				ForwardAddress: &edgeorder.AddressPropertiesArgs{
 * 					ContactDetails: &edgeorder.ContactDetailsArgs{
 * 						ContactName: pulumi.String("XXXX XXXX"),
 * 						EmailList: pulumi.StringArray{
 * 							pulumi.String("xxxx@xxxx.xxx"),
 * 						},
 * 						Phone:          pulumi.String("0000000000"),
 * 						PhoneExtension: pulumi.String(""),
 * 					},
 * 					ShippingAddress: &edgeorder.ShippingAddressArgs{
 * 						AddressType:     pulumi.String(edgeorder.AddressTypeNone),
 * 						City:            pulumi.String("San Francisco"),
 * 						CompanyName:     pulumi.String("Microsoft"),
 * 						Country:         pulumi.String("US"),
 * 						PostalCode:      pulumi.String("94107"),
 * 						StateOrProvince: pulumi.String("CA"),
 * 						StreetAddress1:  pulumi.String("16 TOWNSEND ST"),
 * 						StreetAddress2:  pulumi.String("UNIT 1"),
 * 					},
 * 				},
 * 			},
 * 			Location: pulumi.String("eastus"),
 * 			OrderId:  pulumi.String("/subscriptions/YourSubscriptionId/resourceGroups/YourResourceGroupName/providers/Microsoft.EdgeOrder/locations/eastus/orders/TestOrderName2"),
 * 			OrderItemDetails: &edgeorder.OrderItemDetailsArgs{
 * 				OrderItemType: pulumi.String(edgeorder.OrderItemTypePurchase),
 * 				Preferences: &edgeorder.PreferencesArgs{
 * 					TransportPreferences: &edgeorder.TransportPreferencesArgs{
 * 						PreferredShipmentType: pulumi.String(edgeorder.TransportShipmentTypesMicrosoftManaged),
 * 					},
 * 				},
 * 				ProductDetails: &edgeorder.ProductDetailsArgs{
 * 					HierarchyInformation: &edgeorder.HierarchyInformationArgs{
 * 						ConfigurationName: pulumi.String("edgep_base"),
 * 						ProductFamilyName: pulumi.String("azurestackedge"),
 * 						ProductLineName:   pulumi.String("azurestackedge"),
 * 						ProductName:       pulumi.String("azurestackedgegpu"),
 * 					},
 * 				},
 * 			},
 * 			OrderItemName:     pulumi.String("TestOrderItemName2"),
 * 			ResourceGroupName: pulumi.String("YourResourceGroupName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.edgeorder.OrderItemByName;
 * import com.pulumi.azurenative.edgeorder.OrderItemByNameArgs;
 * import com.pulumi.azurenative.edgeorder.inputs.AddressDetailsArgs;
 * import com.pulumi.azurenative.edgeorder.inputs.AddressPropertiesArgs;
 * import com.pulumi.azurenative.edgeorder.inputs.ContactDetailsArgs;
 * import com.pulumi.azurenative.edgeorder.inputs.ShippingAddressArgs;
 * import com.pulumi.azurenative.edgeorder.inputs.OrderItemDetailsArgs;
 * import com.pulumi.azurenative.edgeorder.inputs.PreferencesArgs;
 * import com.pulumi.azurenative.edgeorder.inputs.TransportPreferencesArgs;
 * import com.pulumi.azurenative.edgeorder.inputs.ProductDetailsArgs;
 * import com.pulumi.azurenative.edgeorder.inputs.HierarchyInformationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var orderItemByName = new OrderItemByName("orderItemByName", OrderItemByNameArgs.builder()
 *             .addressDetails(AddressDetailsArgs.builder()
 *                 .forwardAddress(AddressPropertiesArgs.builder()
 *                     .contactDetails(ContactDetailsArgs.builder()
 *                         .contactName("XXXX XXXX")
 *                         .emailList("xxxx@xxxx.xxx")
 *                         .phone("0000000000")
 *                         .phoneExtension("")
 *                         .build())
 *                     .shippingAddress(ShippingAddressArgs.builder()
 *                         .addressType("None")
 *                         .city("San Francisco")
 *                         .companyName("Microsoft")
 *                         .country("US")
 *                         .postalCode("94107")
 *                         .stateOrProvince("CA")
 *                         .streetAddress1("16 TOWNSEND ST")
 *                         .streetAddress2("UNIT 1")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .location("eastus")
 *             .orderId("/subscriptions/YourSubscriptionId/resourceGroups/YourResourceGroupName/providers/Microsoft.EdgeOrder/locations/eastus/orders/TestOrderName2")
 *             .orderItemDetails(OrderItemDetailsArgs.builder()
 *                 .orderItemType("Purchase")
 *                 .preferences(PreferencesArgs.builder()
 *                     .transportPreferences(TransportPreferencesArgs.builder()
 *                         .preferredShipmentType("MicrosoftManaged")
 *                         .build())
 *                     .build())
 *                 .productDetails(ProductDetailsArgs.builder()
 *                     .hierarchyInformation(HierarchyInformationArgs.builder()
 *                         .configurationName("edgep_base")
 *                         .productFamilyName("azurestackedge")
 *                         .productLineName("azurestackedge")
 *                         .productName("azurestackedgegpu")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .orderItemName("TestOrderItemName2")
 *             .resourceGroupName("YourResourceGroupName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:edgeorder:OrderItemByName TestOrderItemName2 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EdgeOrder/orderItems/{orderItemName}
 * ```
 * @property addressDetails Represents shipping and return address for order item
 * @property location The geo-location where the resource lives
 * @property orderId Id of the order to which order item belongs to
 * @property orderItemDetails Represents order item details.
 * @property orderItemName The name of the order item
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 */
public data class OrderItemByNameArgs(
    public val addressDetails: Output<AddressDetailsArgs>? = null,
    public val location: Output<String>? = null,
    public val orderId: Output<String>? = null,
    public val orderItemDetails: Output<OrderItemDetailsArgs>? = null,
    public val orderItemName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.edgeorder.OrderItemByNameArgs> {
    override fun toJava(): com.pulumi.azurenative.edgeorder.OrderItemByNameArgs =
        com.pulumi.azurenative.edgeorder.OrderItemByNameArgs.builder()
            .addressDetails(addressDetails?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .orderId(orderId?.applyValue({ args0 -> args0 }))
            .orderItemDetails(orderItemDetails?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .orderItemName(orderItemName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [OrderItemByNameArgs].
 */
@PulumiTagMarker
public class OrderItemByNameArgsBuilder internal constructor() {
    private var addressDetails: Output<AddressDetailsArgs>? = null

    private var location: Output<String>? = null

    private var orderId: Output<String>? = null

    private var orderItemDetails: Output<OrderItemDetailsArgs>? = null

    private var orderItemName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Represents shipping and return address for order item
     */
    @JvmName("lfqhiviwmruhmycv")
    public suspend fun addressDetails(`value`: Output<AddressDetailsArgs>) {
        this.addressDetails = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("jewgvwefgwchriif")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Id of the order to which order item belongs to
     */
    @JvmName("qutyopngkypdslqy")
    public suspend fun orderId(`value`: Output<String>) {
        this.orderId = value
    }

    /**
     * @param value Represents order item details.
     */
    @JvmName("fvykutwacwrbxmkx")
    public suspend fun orderItemDetails(`value`: Output<OrderItemDetailsArgs>) {
        this.orderItemDetails = value
    }

    /**
     * @param value The name of the order item
     */
    @JvmName("vwfcehtytfcvxlmj")
    public suspend fun orderItemName(`value`: Output<String>) {
        this.orderItemName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ylwjdyywidsnmimr")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("qrqmnujayssmouql")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Represents shipping and return address for order item
     */
    @JvmName("pprrmqaqooyjjuxy")
    public suspend fun addressDetails(`value`: AddressDetailsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addressDetails = mapped
    }

    /**
     * @param argument Represents shipping and return address for order item
     */
    @JvmName("bhkxranuxwtusclv")
    public suspend fun addressDetails(argument: suspend AddressDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = AddressDetailsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.addressDetails = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("avaihdybufynlglm")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Id of the order to which order item belongs to
     */
    @JvmName("mwwfxmotnnhouilh")
    public suspend fun orderId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.orderId = mapped
    }

    /**
     * @param value Represents order item details.
     */
    @JvmName("bexgqtlecstrnryw")
    public suspend fun orderItemDetails(`value`: OrderItemDetailsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.orderItemDetails = mapped
    }

    /**
     * @param argument Represents order item details.
     */
    @JvmName("xstgtlukdlyfdpju")
    public suspend fun orderItemDetails(argument: suspend OrderItemDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = OrderItemDetailsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.orderItemDetails = mapped
    }

    /**
     * @param value The name of the order item
     */
    @JvmName("ksdthrofhimjulqh")
    public suspend fun orderItemName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.orderItemName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("bsbvgrmfsjyftxlj")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("dfnbetwauerqaebu")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("hvtfxhslhjgssqco")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): OrderItemByNameArgs = OrderItemByNameArgs(
        addressDetails = addressDetails,
        location = location,
        orderId = orderId,
        orderItemDetails = orderItemDetails,
        orderItemName = orderItemName,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
