@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.edgeorder.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Type of address.
 */
public enum class AddressType(
    public val javaValue: com.pulumi.azurenative.edgeorder.enums.AddressType,
) : ConvertibleToJava<com.pulumi.azurenative.edgeorder.enums.AddressType> {
    /**
     * Address type not known.
     */
    None(com.pulumi.azurenative.edgeorder.enums.AddressType.None),

    /**
     * Residential Address.
     */
    Residential(com.pulumi.azurenative.edgeorder.enums.AddressType.Residential),

    /**
     * Commercial Address.
     */
    Commercial(com.pulumi.azurenative.edgeorder.enums.AddressType.Commercial),
    ;

    override fun toJava(): com.pulumi.azurenative.edgeorder.enums.AddressType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.edgeorder.enums.AddressType): AddressType =
            AddressType.values().first { it.javaValue == javaType }
    }
}
