@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.edgeorder.kotlin.inputs

import com.pulumi.azurenative.edgeorder.inputs.AdditionalConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Additional Configuration details.
 * @property hierarchyInformation Hierarchy of the product which uniquely identifies the configuration.
 * @property quantity Quantity of the product.
 */
public data class AdditionalConfigurationArgs(
    public val hierarchyInformation: Output<HierarchyInformationArgs>,
    public val quantity: Output<Int>,
) : ConvertibleToJava<com.pulumi.azurenative.edgeorder.inputs.AdditionalConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.edgeorder.inputs.AdditionalConfigurationArgs =
        com.pulumi.azurenative.edgeorder.inputs.AdditionalConfigurationArgs.builder()
            .hierarchyInformation(
                hierarchyInformation.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .quantity(quantity.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AdditionalConfigurationArgs].
 */
@PulumiTagMarker
public class AdditionalConfigurationArgsBuilder internal constructor() {
    private var hierarchyInformation: Output<HierarchyInformationArgs>? = null

    private var quantity: Output<Int>? = null

    /**
     * @param value Hierarchy of the product which uniquely identifies the configuration.
     */
    @JvmName("clurfsqbhvirnoov")
    public suspend fun hierarchyInformation(`value`: Output<HierarchyInformationArgs>) {
        this.hierarchyInformation = value
    }

    /**
     * @param value Quantity of the product.
     */
    @JvmName("ufhjvujgaornicfp")
    public suspend fun quantity(`value`: Output<Int>) {
        this.quantity = value
    }

    /**
     * @param value Hierarchy of the product which uniquely identifies the configuration.
     */
    @JvmName("lushpypyivydvcyu")
    public suspend fun hierarchyInformation(`value`: HierarchyInformationArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hierarchyInformation = mapped
    }

    /**
     * @param argument Hierarchy of the product which uniquely identifies the configuration.
     */
    @JvmName("fwlaadmnxqhvwryi")
    public suspend
    fun hierarchyInformation(argument: suspend HierarchyInformationArgsBuilder.() -> Unit) {
        val toBeMapped = HierarchyInformationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.hierarchyInformation = mapped
    }

    /**
     * @param value Quantity of the product.
     */
    @JvmName("yjwkprfnodhtluyr")
    public suspend fun quantity(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.quantity = mapped
    }

    internal fun build(): AdditionalConfigurationArgs = AdditionalConfigurationArgs(
        hierarchyInformation = hierarchyInformation ?: throw
            PulumiNullFieldException("hierarchyInformation"),
        quantity = quantity ?: throw PulumiNullFieldException("quantity"),
    )
}
