@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.edgeorder.kotlin.inputs

import com.pulumi.azurenative.edgeorder.inputs.ChildConfigurationFilter.builder
import com.pulumi.azurenative.edgeorder.kotlin.enums.ChildConfigurationType
import com.pulumi.core.Either
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Child configuration filter.
 * @property childConfigurationTypes Filter to fetch all child configurations belonging to the given list of configuration types.
 * @property hierarchyInformations The list of child configuration hierarchy customer wants to filter for the given configuration.
 */
public data class ChildConfigurationFilter(
    public val childConfigurationTypes: List<Either<String, ChildConfigurationType>>? = null,
    public val hierarchyInformations: List<HierarchyInformation>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.edgeorder.inputs.ChildConfigurationFilter> {
    override fun toJava(): com.pulumi.azurenative.edgeorder.inputs.ChildConfigurationFilter =
        com.pulumi.azurenative.edgeorder.inputs.ChildConfigurationFilter.builder()
            .childConfigurationTypes(
                childConfigurationTypes?.let({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                    })
                }),
            )
            .hierarchyInformations(
                hierarchyInformations?.let({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [ChildConfigurationFilter].
 */
@PulumiTagMarker
public class ChildConfigurationFilterBuilder internal constructor() {
    private var childConfigurationTypes: List<Either<String, ChildConfigurationType>>? = null

    private var hierarchyInformations: List<HierarchyInformation>? = null

    /**
     * @param value Filter to fetch all child configurations belonging to the given list of configuration types.
     */
    @JvmName("srlakvnnwagdmqup")
    public suspend
    fun childConfigurationTypes(`value`: List<Either<String, ChildConfigurationType>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.childConfigurationTypes = mapped
    }

    /**
     * @param values Filter to fetch all child configurations belonging to the given list of configuration types.
     */
    @JvmName("hvcxyuwtsfkdrxim")
    public suspend fun childConfigurationTypes(
        vararg
        values: Either<String, ChildConfigurationType>,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.childConfigurationTypes = mapped
    }

    /**
     * @param value The list of child configuration hierarchy customer wants to filter for the given configuration.
     */
    @JvmName("kksnqhfsfitklrnd")
    public suspend fun hierarchyInformations(`value`: List<HierarchyInformation>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.hierarchyInformations = mapped
    }

    /**
     * @param argument The list of child configuration hierarchy customer wants to filter for the given configuration.
     */
    @JvmName("ltcedxfwslsqfgas")
    public suspend
    fun hierarchyInformations(argument: List<suspend HierarchyInformationBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            HierarchyInformationBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.hierarchyInformations = mapped
    }

    /**
     * @param argument The list of child configuration hierarchy customer wants to filter for the given configuration.
     */
    @JvmName("gijnhglknmcmelrf")
    public suspend fun hierarchyInformations(
        vararg
        argument: suspend HierarchyInformationBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            HierarchyInformationBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.hierarchyInformations = mapped
    }

    /**
     * @param argument The list of child configuration hierarchy customer wants to filter for the given configuration.
     */
    @JvmName("lcdrljhaligywalu")
    public suspend
    fun hierarchyInformations(argument: suspend HierarchyInformationBuilder.() -> Unit) {
        val toBeMapped = listOf(HierarchyInformationBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.hierarchyInformations = mapped
    }

    /**
     * @param values The list of child configuration hierarchy customer wants to filter for the given configuration.
     */
    @JvmName("qnxqeumkkyebluua")
    public suspend fun hierarchyInformations(vararg values: HierarchyInformation) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.hierarchyInformations = mapped
    }

    internal fun build(): ChildConfigurationFilter = ChildConfigurationFilter(
        childConfigurationTypes = childConfigurationTypes,
        hierarchyInformations = hierarchyInformations,
    )
}
