@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.edgeorder.kotlin.inputs

import com.pulumi.azurenative.edgeorder.inputs.EncryptionPreferencesArgs.builder
import com.pulumi.azurenative.edgeorder.kotlin.enums.DoubleEncryptionStatus
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Preferences related to the double encryption
 * @property doubleEncryptionStatus Double encryption status as entered by the customer. It is compulsory to give this parameter if the 'Deny' or 'Disabled' policy is configured.
 */
public data class EncryptionPreferencesArgs(
    public val doubleEncryptionStatus: Output<Either<String, DoubleEncryptionStatus>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.edgeorder.inputs.EncryptionPreferencesArgs> {
    override fun toJava(): com.pulumi.azurenative.edgeorder.inputs.EncryptionPreferencesArgs =
        com.pulumi.azurenative.edgeorder.inputs.EncryptionPreferencesArgs.builder()
            .doubleEncryptionStatus(
                doubleEncryptionStatus?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            ).build()
}

/**
 * Builder for [EncryptionPreferencesArgs].
 */
@PulumiTagMarker
public class EncryptionPreferencesArgsBuilder internal constructor() {
    private var doubleEncryptionStatus: Output<Either<String, DoubleEncryptionStatus>>? = null

    /**
     * @param value Double encryption status as entered by the customer. It is compulsory to give this parameter if the 'Deny' or 'Disabled' policy is configured.
     */
    @JvmName("ebycrapfwjhyriak")
    public suspend
    fun doubleEncryptionStatus(`value`: Output<Either<String, DoubleEncryptionStatus>>) {
        this.doubleEncryptionStatus = value
    }

    /**
     * @param value Double encryption status as entered by the customer. It is compulsory to give this parameter if the 'Deny' or 'Disabled' policy is configured.
     */
    @JvmName("jfblgthklximraof")
    public suspend fun doubleEncryptionStatus(`value`: Either<String, DoubleEncryptionStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.doubleEncryptionStatus = mapped
    }

    /**
     * @param value Double encryption status as entered by the customer. It is compulsory to give this parameter if the 'Deny' or 'Disabled' policy is configured.
     */
    @JvmName("blyakbbrgjkjfate")
    public fun doubleEncryptionStatus(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DoubleEncryptionStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.doubleEncryptionStatus = mapped
    }

    /**
     * @param value Double encryption status as entered by the customer. It is compulsory to give this parameter if the 'Deny' or 'Disabled' policy is configured.
     */
    @JvmName("jyhywlxbegaachae")
    public fun doubleEncryptionStatus(`value`: DoubleEncryptionStatus) {
        val toBeMapped = Either.ofRight<String, DoubleEncryptionStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.doubleEncryptionStatus = mapped
    }

    internal fun build(): EncryptionPreferencesArgs = EncryptionPreferencesArgs(
        doubleEncryptionStatus = doubleEncryptionStatus,
    )
}
