@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.edgeorder.kotlin.inputs

import com.pulumi.azurenative.edgeorder.inputs.ListProductFamiliesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property customerSubscriptionDetails Customer subscription properties. Clients can display available products to unregistered customers by explicitly passing subscription details
 * @property expand $expand is supported on configurations parameter for product, which provides details on the configurations for the product.
 * @property filterableProperties Dictionary of filterable properties on product family.
 * @property skipToken $skipToken is supported on list of product families, which provides the next page in the list of product families.
 */
public data class ListProductFamiliesPlainArgs(
    public val customerSubscriptionDetails: CustomerSubscriptionDetails? = null,
    public val expand: String? = null,
    public val filterableProperties: Map<String, List<FilterableProperty>>,
    public val skipToken: String? = null,
) : ConvertibleToJava<com.pulumi.azurenative.edgeorder.inputs.ListProductFamiliesPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.edgeorder.inputs.ListProductFamiliesPlainArgs =
        com.pulumi.azurenative.edgeorder.inputs.ListProductFamiliesPlainArgs.builder()
            .customerSubscriptionDetails(
                customerSubscriptionDetails?.let({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .expand(expand?.let({ args0 -> args0 }))
            .filterableProperties(
                filterableProperties.let({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
                    }).toMap()
                }),
            )
            .skipToken(skipToken?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListProductFamiliesPlainArgs].
 */
@PulumiTagMarker
public class ListProductFamiliesPlainArgsBuilder internal constructor() {
    private var customerSubscriptionDetails: CustomerSubscriptionDetails? = null

    private var expand: String? = null

    private var filterableProperties: Map<String, List<FilterableProperty>>? = null

    private var skipToken: String? = null

    /**
     * @param value Customer subscription properties. Clients can display available products to unregistered customers by explicitly passing subscription details
     */
    @JvmName("fylybttyhdtqtuct")
    public suspend fun customerSubscriptionDetails(`value`: CustomerSubscriptionDetails?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.customerSubscriptionDetails = mapped
    }

    /**
     * @param argument Customer subscription properties. Clients can display available products to unregistered customers by explicitly passing subscription details
     */
    @JvmName("tdspgkhteuwvwoxj")
    public suspend
    fun customerSubscriptionDetails(argument: suspend CustomerSubscriptionDetailsBuilder.() -> Unit) {
        val toBeMapped = CustomerSubscriptionDetailsBuilder().applySuspend { argument() }.build()
        val mapped = toBeMapped
        this.customerSubscriptionDetails = mapped
    }

    /**
     * @param value $expand is supported on configurations parameter for product, which provides details on the configurations for the product.
     */
    @JvmName("jsvrtpijtoywwvui")
    public suspend fun expand(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.expand = mapped
    }

    /**
     * @param value Dictionary of filterable properties on product family.
     */
    @JvmName("sukomkcsuidyxkuu")
    public suspend fun filterableProperties(`value`: Map<String, List<FilterableProperty>>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filterableProperties = mapped
    }

    /**
     * @param values Dictionary of filterable properties on product family.
     */
    @JvmName("dnckojkporedrfer")
    public fun filterableProperties(vararg values: Pair<String, List<FilterableProperty>>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filterableProperties = mapped
    }

    /**
     * @param value $skipToken is supported on list of product families, which provides the next page in the list of product families.
     */
    @JvmName("rdpaxolsngfudgww")
    public suspend fun skipToken(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.skipToken = mapped
    }

    internal fun build(): ListProductFamiliesPlainArgs = ListProductFamiliesPlainArgs(
        customerSubscriptionDetails = customerSubscriptionDetails,
        expand = expand,
        filterableProperties = filterableProperties ?: throw
            PulumiNullFieldException("filterableProperties"),
        skipToken = skipToken,
    )
}
