@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.edgeorder.kotlin.inputs

import com.pulumi.azurenative.edgeorder.inputs.ManagementResourcePreferencesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Management resource preference to link device
 * @property preferredManagementResourceId Customer preferred Management resource ARM ID
 */
public data class ManagementResourcePreferencesArgs(
    public val preferredManagementResourceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.edgeorder.inputs.ManagementResourcePreferencesArgs> {
    override fun toJava(): com.pulumi.azurenative.edgeorder.inputs.ManagementResourcePreferencesArgs =
        com.pulumi.azurenative.edgeorder.inputs.ManagementResourcePreferencesArgs.builder()
            .preferredManagementResourceId(
                preferredManagementResourceId?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [ManagementResourcePreferencesArgs].
 */
@PulumiTagMarker
public class ManagementResourcePreferencesArgsBuilder internal constructor() {
    private var preferredManagementResourceId: Output<String>? = null

    /**
     * @param value Customer preferred Management resource ARM ID
     */
    @JvmName("rxbchdfinjcthjqo")
    public suspend fun preferredManagementResourceId(`value`: Output<String>) {
        this.preferredManagementResourceId = value
    }

    /**
     * @param value Customer preferred Management resource ARM ID
     */
    @JvmName("dukgxjpljurtbvsy")
    public suspend fun preferredManagementResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preferredManagementResourceId = mapped
    }

    internal fun build(): ManagementResourcePreferencesArgs = ManagementResourcePreferencesArgs(
        preferredManagementResourceId = preferredManagementResourceId,
    )
}
