@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.edgeorder.kotlin.inputs

import com.pulumi.azurenative.edgeorder.inputs.OrderItemDetailsArgs.builder
import com.pulumi.azurenative.edgeorder.kotlin.enums.OrderItemType
import com.pulumi.azurenative.edgeorder.kotlin.enums.OrderMode
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Order item details
 * @property notificationEmailList Additional notification email list
 * @property orderItemMode Defines the mode of the Order item.
 * @property orderItemType Order item type.
 * @property preferences Customer notification Preferences
 * @property productDetails Unique identifier for configuration.
 */
public data class OrderItemDetailsArgs(
    public val notificationEmailList: Output<List<String>>? = null,
    public val orderItemMode: Output<Either<String, OrderMode>>? = null,
    public val orderItemType: Output<Either<String, OrderItemType>>,
    public val preferences: Output<PreferencesArgs>? = null,
    public val productDetails: Output<ProductDetailsArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.edgeorder.inputs.OrderItemDetailsArgs> {
    override fun toJava(): com.pulumi.azurenative.edgeorder.inputs.OrderItemDetailsArgs =
        com.pulumi.azurenative.edgeorder.inputs.OrderItemDetailsArgs.builder()
            .notificationEmailList(notificationEmailList?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .orderItemMode(
                orderItemMode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .orderItemType(
                orderItemType.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .preferences(preferences?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .productDetails(
                productDetails.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [OrderItemDetailsArgs].
 */
@PulumiTagMarker
public class OrderItemDetailsArgsBuilder internal constructor() {
    private var notificationEmailList: Output<List<String>>? = null

    private var orderItemMode: Output<Either<String, OrderMode>>? = null

    private var orderItemType: Output<Either<String, OrderItemType>>? = null

    private var preferences: Output<PreferencesArgs>? = null

    private var productDetails: Output<ProductDetailsArgs>? = null

    /**
     * @param value Additional notification email list
     */
    @JvmName("kchhqrklgdviwexe")
    public suspend fun notificationEmailList(`value`: Output<List<String>>) {
        this.notificationEmailList = value
    }

    @JvmName("imkifgefjrdhiwog")
    public suspend fun notificationEmailList(vararg values: Output<String>) {
        this.notificationEmailList = Output.all(values.asList())
    }

    /**
     * @param values Additional notification email list
     */
    @JvmName("enlgdvdpujkehuog")
    public suspend fun notificationEmailList(values: List<Output<String>>) {
        this.notificationEmailList = Output.all(values)
    }

    /**
     * @param value Defines the mode of the Order item.
     */
    @JvmName("pibmcdfgamopflck")
    public suspend fun orderItemMode(`value`: Output<Either<String, OrderMode>>) {
        this.orderItemMode = value
    }

    /**
     * @param value Order item type.
     */
    @JvmName("mmxilkvdkqctagua")
    public suspend fun orderItemType(`value`: Output<Either<String, OrderItemType>>) {
        this.orderItemType = value
    }

    /**
     * @param value Customer notification Preferences
     */
    @JvmName("hsjictcuykkivklt")
    public suspend fun preferences(`value`: Output<PreferencesArgs>) {
        this.preferences = value
    }

    /**
     * @param value Unique identifier for configuration.
     */
    @JvmName("puuldsmndaguxcvs")
    public suspend fun productDetails(`value`: Output<ProductDetailsArgs>) {
        this.productDetails = value
    }

    /**
     * @param value Additional notification email list
     */
    @JvmName("ofxtihbworklydsc")
    public suspend fun notificationEmailList(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notificationEmailList = mapped
    }

    /**
     * @param values Additional notification email list
     */
    @JvmName("thwuhjnnrobwulwa")
    public suspend fun notificationEmailList(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.notificationEmailList = mapped
    }

    /**
     * @param value Defines the mode of the Order item.
     */
    @JvmName("eqrgbbddnckbxmfc")
    public suspend fun orderItemMode(`value`: Either<String, OrderMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.orderItemMode = mapped
    }

    /**
     * @param value Defines the mode of the Order item.
     */
    @JvmName("kemjjxtsbbmsqqan")
    public fun orderItemMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, OrderMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.orderItemMode = mapped
    }

    /**
     * @param value Defines the mode of the Order item.
     */
    @JvmName("deeekwwptnfgctqx")
    public fun orderItemMode(`value`: OrderMode) {
        val toBeMapped = Either.ofRight<String, OrderMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.orderItemMode = mapped
    }

    /**
     * @param value Order item type.
     */
    @JvmName("bnkvswggvxugeaps")
    public suspend fun orderItemType(`value`: Either<String, OrderItemType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.orderItemType = mapped
    }

    /**
     * @param value Order item type.
     */
    @JvmName("unyseuobpohmaqwt")
    public fun orderItemType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, OrderItemType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.orderItemType = mapped
    }

    /**
     * @param value Order item type.
     */
    @JvmName("qtosnrymkvltqaga")
    public fun orderItemType(`value`: OrderItemType) {
        val toBeMapped = Either.ofRight<String, OrderItemType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.orderItemType = mapped
    }

    /**
     * @param value Customer notification Preferences
     */
    @JvmName("tcamleloipipqokt")
    public suspend fun preferences(`value`: PreferencesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preferences = mapped
    }

    /**
     * @param argument Customer notification Preferences
     */
    @JvmName("seuqqkljebwuhavo")
    public suspend fun preferences(argument: suspend PreferencesArgsBuilder.() -> Unit) {
        val toBeMapped = PreferencesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.preferences = mapped
    }

    /**
     * @param value Unique identifier for configuration.
     */
    @JvmName("cdpkemwaodxpxsvl")
    public suspend fun productDetails(`value`: ProductDetailsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.productDetails = mapped
    }

    /**
     * @param argument Unique identifier for configuration.
     */
    @JvmName("tlubvhtitauhphla")
    public suspend fun productDetails(argument: suspend ProductDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = ProductDetailsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.productDetails = mapped
    }

    internal fun build(): OrderItemDetailsArgs = OrderItemDetailsArgs(
        notificationEmailList = notificationEmailList,
        orderItemMode = orderItemMode,
        orderItemType = orderItemType ?: throw PulumiNullFieldException("orderItemType"),
        preferences = preferences,
        productDetails = productDetails ?: throw PulumiNullFieldException("productDetails"),
    )
}
