@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.edgeorder.kotlin.inputs

import com.pulumi.azurenative.edgeorder.inputs.ShippingAddressArgs.builder
import com.pulumi.azurenative.edgeorder.kotlin.enums.AddressType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Shipping address where customer wishes to receive the device.
 * @property addressType Type of address.
 * @property city Name of the City.
 * @property companyName Name of the company.
 * @property country Name of the Country.
 * @property postalCode Postal code.
 * @property stateOrProvince Name of the State or Province.
 * @property streetAddress1 Street Address line 1.
 * @property streetAddress2 Street Address line 2.
 * @property streetAddress3 Street Address line 3.
 * @property zipExtendedCode Extended Zip Code.
 */
public data class ShippingAddressArgs(
    public val addressType: Output<Either<String, AddressType>>? = null,
    public val city: Output<String>? = null,
    public val companyName: Output<String>? = null,
    public val country: Output<String>,
    public val postalCode: Output<String>? = null,
    public val stateOrProvince: Output<String>? = null,
    public val streetAddress1: Output<String>,
    public val streetAddress2: Output<String>? = null,
    public val streetAddress3: Output<String>? = null,
    public val zipExtendedCode: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.edgeorder.inputs.ShippingAddressArgs> {
    override fun toJava(): com.pulumi.azurenative.edgeorder.inputs.ShippingAddressArgs =
        com.pulumi.azurenative.edgeorder.inputs.ShippingAddressArgs.builder()
            .addressType(
                addressType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .city(city?.applyValue({ args0 -> args0 }))
            .companyName(companyName?.applyValue({ args0 -> args0 }))
            .country(country.applyValue({ args0 -> args0 }))
            .postalCode(postalCode?.applyValue({ args0 -> args0 }))
            .stateOrProvince(stateOrProvince?.applyValue({ args0 -> args0 }))
            .streetAddress1(streetAddress1.applyValue({ args0 -> args0 }))
            .streetAddress2(streetAddress2?.applyValue({ args0 -> args0 }))
            .streetAddress3(streetAddress3?.applyValue({ args0 -> args0 }))
            .zipExtendedCode(zipExtendedCode?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ShippingAddressArgs].
 */
@PulumiTagMarker
public class ShippingAddressArgsBuilder internal constructor() {
    private var addressType: Output<Either<String, AddressType>>? = null

    private var city: Output<String>? = null

    private var companyName: Output<String>? = null

    private var country: Output<String>? = null

    private var postalCode: Output<String>? = null

    private var stateOrProvince: Output<String>? = null

    private var streetAddress1: Output<String>? = null

    private var streetAddress2: Output<String>? = null

    private var streetAddress3: Output<String>? = null

    private var zipExtendedCode: Output<String>? = null

    /**
     * @param value Type of address.
     */
    @JvmName("xcwkwoopoanpwgqq")
    public suspend fun addressType(`value`: Output<Either<String, AddressType>>) {
        this.addressType = value
    }

    /**
     * @param value Name of the City.
     */
    @JvmName("xampajgmtexduicp")
    public suspend fun city(`value`: Output<String>) {
        this.city = value
    }

    /**
     * @param value Name of the company.
     */
    @JvmName("jsybsqannuywfneh")
    public suspend fun companyName(`value`: Output<String>) {
        this.companyName = value
    }

    /**
     * @param value Name of the Country.
     */
    @JvmName("svolcpmqllwonoob")
    public suspend fun country(`value`: Output<String>) {
        this.country = value
    }

    /**
     * @param value Postal code.
     */
    @JvmName("nkirqgxvhbcikffr")
    public suspend fun postalCode(`value`: Output<String>) {
        this.postalCode = value
    }

    /**
     * @param value Name of the State or Province.
     */
    @JvmName("oeftnabbullojcoa")
    public suspend fun stateOrProvince(`value`: Output<String>) {
        this.stateOrProvince = value
    }

    /**
     * @param value Street Address line 1.
     */
    @JvmName("mdpvqabiogyifkka")
    public suspend fun streetAddress1(`value`: Output<String>) {
        this.streetAddress1 = value
    }

    /**
     * @param value Street Address line 2.
     */
    @JvmName("vcxlwmycycxteytr")
    public suspend fun streetAddress2(`value`: Output<String>) {
        this.streetAddress2 = value
    }

    /**
     * @param value Street Address line 3.
     */
    @JvmName("eanstvgxcrcbgsqr")
    public suspend fun streetAddress3(`value`: Output<String>) {
        this.streetAddress3 = value
    }

    /**
     * @param value Extended Zip Code.
     */
    @JvmName("psrpvjdexlslfmtw")
    public suspend fun zipExtendedCode(`value`: Output<String>) {
        this.zipExtendedCode = value
    }

    /**
     * @param value Type of address.
     */
    @JvmName("kfhuoiqksyppjdvw")
    public suspend fun addressType(`value`: Either<String, AddressType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addressType = mapped
    }

    /**
     * @param value Type of address.
     */
    @JvmName("wxtombrimempkwom")
    public fun addressType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AddressType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.addressType = mapped
    }

    /**
     * @param value Type of address.
     */
    @JvmName("ablcmxjgkrypojxn")
    public fun addressType(`value`: AddressType) {
        val toBeMapped = Either.ofRight<String, AddressType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.addressType = mapped
    }

    /**
     * @param value Name of the City.
     */
    @JvmName("adqfifxqhkxpvwag")
    public suspend fun city(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.city = mapped
    }

    /**
     * @param value Name of the company.
     */
    @JvmName("mahyureetlqeooio")
    public suspend fun companyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.companyName = mapped
    }

    /**
     * @param value Name of the Country.
     */
    @JvmName("lwymhrupkutqfluc")
    public suspend fun country(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.country = mapped
    }

    /**
     * @param value Postal code.
     */
    @JvmName("vowtmmaafxmwcdcy")
    public suspend fun postalCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.postalCode = mapped
    }

    /**
     * @param value Name of the State or Province.
     */
    @JvmName("mqxmxnapoiygoajv")
    public suspend fun stateOrProvince(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stateOrProvince = mapped
    }

    /**
     * @param value Street Address line 1.
     */
    @JvmName("oqbhgwymplgdnlmb")
    public suspend fun streetAddress1(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.streetAddress1 = mapped
    }

    /**
     * @param value Street Address line 2.
     */
    @JvmName("lhnmkxrabxeokcgu")
    public suspend fun streetAddress2(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.streetAddress2 = mapped
    }

    /**
     * @param value Street Address line 3.
     */
    @JvmName("iakkdggedhgsqdaa")
    public suspend fun streetAddress3(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.streetAddress3 = mapped
    }

    /**
     * @param value Extended Zip Code.
     */
    @JvmName("nuusckprhlkpfcip")
    public suspend fun zipExtendedCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zipExtendedCode = mapped
    }

    internal fun build(): ShippingAddressArgs = ShippingAddressArgs(
        addressType = addressType,
        city = city,
        companyName = companyName,
        country = country ?: throw PulumiNullFieldException("country"),
        postalCode = postalCode,
        stateOrProvince = stateOrProvince,
        streetAddress1 = streetAddress1 ?: throw PulumiNullFieldException("streetAddress1"),
        streetAddress2 = streetAddress2,
        streetAddress3 = streetAddress3,
        zipExtendedCode = zipExtendedCode,
    )
}
