@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.edgeorder.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 * Additional Configuration details.
 * @property hierarchyInformation Hierarchy of the product which uniquely identifies the configuration.
 * @property quantity Quantity of the product.
 */
public data class AdditionalConfigurationResponse(
    public val hierarchyInformation: HierarchyInformationResponse,
    public val quantity: Int,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.edgeorder.outputs.AdditionalConfigurationResponse):
            AdditionalConfigurationResponse = AdditionalConfigurationResponse(
            hierarchyInformation = javaType.hierarchyInformation().let({ args0 ->
                com.pulumi.azurenative.edgeorder.kotlin.outputs.HierarchyInformationResponse.Companion.toKotlin(args0)
            }),
            quantity = javaType.quantity(),
        )
    }
}
