@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.edgeorder.kotlin.outputs

import kotlin.Suppress

/**
 * Address details for an order item.
 * @property forwardAddress Customer address and contact details. It should be address resource
 * @property returnAddress Return shipping address
 */
public data class AddressDetailsResponse(
    public val forwardAddress: AddressPropertiesResponse,
    public val returnAddress: AddressPropertiesResponse,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.edgeorder.outputs.AddressDetailsResponse):
            AddressDetailsResponse = AddressDetailsResponse(
            forwardAddress = javaType.forwardAddress().let({ args0 ->
                com.pulumi.azurenative.edgeorder.kotlin.outputs.AddressPropertiesResponse.Companion.toKotlin(args0)
            }),
            returnAddress = javaType.returnAddress().let({ args0 ->
                com.pulumi.azurenative.edgeorder.kotlin.outputs.AddressPropertiesResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
