@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.edgeorder.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Category related properties of a child configuration.
 * @property categoryDisplayName Category display name of the child configuration.
 * @property categoryName Category name of the child configuration.
 * @property description Description text for the category.
 * @property links Links for the category.
 */
public data class CategoryInformationResponse(
    public val categoryDisplayName: String? = null,
    public val categoryName: String? = null,
    public val description: String? = null,
    public val links: List<LinkResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.edgeorder.outputs.CategoryInformationResponse):
            CategoryInformationResponse = CategoryInformationResponse(
            categoryDisplayName = javaType.categoryDisplayName().map({ args0 -> args0 }).orElse(null),
            categoryName = javaType.categoryName().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            links = javaType.links().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.edgeorder.kotlin.outputs.LinkResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
