@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.edgeorder.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Device details.
 * @property managementResourceId Management Resource Id
 * @property managementResourceTenantId Management Resource Tenant ID
 * @property serialNumber device serial number
 */
public data class DeviceDetailsResponse(
    public val managementResourceId: String,
    public val managementResourceTenantId: String,
    public val serialNumber: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.edgeorder.outputs.DeviceDetailsResponse):
            DeviceDetailsResponse = DeviceDetailsResponse(
            managementResourceId = javaType.managementResourceId(),
            managementResourceTenantId = javaType.managementResourceTenantId(),
            serialNumber = javaType.serialNumber(),
        )
    }
}
