@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.edgeorder.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Billing type Purchase meter details.
 * @property billingType Represents billing type.
 * Expected value is 'Purchase'.
 * @property chargingType Charging type.
 * @property multiplier Billing unit applicable for Pav2 billing.
 * @property productId Product Id.
 * @property skuId Sku Id.
 * @property termId Term Id.
 */
public data class PurchaseMeterDetailsResponse(
    public val billingType: String,
    public val chargingType: String,
    public val multiplier: Double,
    public val productId: String,
    public val skuId: String,
    public val termId: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.edgeorder.outputs.PurchaseMeterDetailsResponse):
            PurchaseMeterDetailsResponse = PurchaseMeterDetailsResponse(
            billingType = javaType.billingType(),
            chargingType = javaType.chargingType(),
            multiplier = javaType.multiplier(),
            productId = javaType.productId(),
            skuId = javaType.skuId(),
            termId = javaType.termId(),
        )
    }
}
